package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Origination(
    routes: Optional[Iterable[zio.aws.chimesdkvoice.model.OriginationRoute]] =
      Optional.Absent,
    disabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.Origination = {
    import Origination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.Origination
      .builder()
      .optionallyWith(
        routes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routes)
      .optionallyWith(disabled.map(value => value: java.lang.Boolean))(
        _.disabled
      )
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.Origination.ReadOnly =
    zio.aws.chimesdkvoice.model.Origination.wrap(buildAwsValue())
}
object Origination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.Origination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.Origination =
      zio.aws.chimesdkvoice.model.Origination(
        routes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        disabled.map(value => value)
      )
    def routes
        : Optional[List[zio.aws.chimesdkvoice.model.OriginationRoute.ReadOnly]]
    def disabled: Optional[Boolean]
    def getRoutes: ZIO[Any, AwsError, List[
      zio.aws.chimesdkvoice.model.OriginationRoute.ReadOnly
    ]] = AwsError.unwrapOptionField("routes", routes)
    def getDisabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("disabled", disabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.Origination
  ) extends zio.aws.chimesdkvoice.model.Origination.ReadOnly {
    override val routes: Optional[
      List[zio.aws.chimesdkvoice.model.OriginationRoute.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.routes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkvoice.model.OriginationRoute.wrap(item)
        }.toList
      )
    override val disabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.disabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.Origination
  ): zio.aws.chimesdkvoice.model.Origination.ReadOnly = new Wrapper(impl)
}
