package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListVoiceConnectorGroupsResponse(
    voiceConnectorGroups: Optional[
      Iterable[zio.aws.chimesdkvoice.model.VoiceConnectorGroup]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorGroupsResponse = {
    import ListVoiceConnectorGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorGroupsResponse
      .builder()
      .optionallyWith(
        voiceConnectorGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.voiceConnectorGroups)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.ListVoiceConnectorGroupsResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.ListVoiceConnectorGroupsResponse
      .wrap(buildAwsValue())
}
object ListVoiceConnectorGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.ListVoiceConnectorGroupsResponse =
      zio.aws.chimesdkvoice.model.ListVoiceConnectorGroupsResponse(
        voiceConnectorGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def voiceConnectorGroups: Optional[
      List[zio.aws.chimesdkvoice.model.VoiceConnectorGroup.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getVoiceConnectorGroups: ZIO[Any, AwsError, List[
      zio.aws.chimesdkvoice.model.VoiceConnectorGroup.ReadOnly
    ]] =
      AwsError.unwrapOptionField("voiceConnectorGroups", voiceConnectorGroups)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorGroupsResponse
  ) extends zio.aws.chimesdkvoice.model.ListVoiceConnectorGroupsResponse.ReadOnly {
    override val voiceConnectorGroups: Optional[
      List[zio.aws.chimesdkvoice.model.VoiceConnectorGroup.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.voiceConnectorGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkvoice.model.VoiceConnectorGroup.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorGroupsResponse
  ): zio.aws.chimesdkvoice.model.ListVoiceConnectorGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
