package zio.aws.chimesdkvoice.model
import zio.aws.chimesdkvoice.model.primitives.ResultMax
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListVoiceConnectorGroupsRequest(
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[ResultMax] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorGroupsRequest = {
    import ListVoiceConnectorGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorGroupsRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => ResultMax.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.ListVoiceConnectorGroupsRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.ListVoiceConnectorGroupsRequest
      .wrap(buildAwsValue())
}
object ListVoiceConnectorGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.ListVoiceConnectorGroupsRequest =
      zio.aws.chimesdkvoice.model.ListVoiceConnectorGroupsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[String]
    def maxResults: Optional[ResultMax]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ResultMax] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorGroupsRequest
  ) extends zio.aws.chimesdkvoice.model.ListVoiceConnectorGroupsRequest.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[ResultMax] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.chimesdkvoice.model.primitives.ResultMax(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorGroupsRequest
  ): zio.aws.chimesdkvoice.model.ListVoiceConnectorGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
