package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPhoneNumbersResponse(
    phoneNumbers: Optional[Iterable[zio.aws.chimesdkvoice.model.PhoneNumber]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersResponse = {
    import ListPhoneNumbersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersResponse
      .builder()
      .optionallyWith(
        phoneNumbers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phoneNumbers)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.ListPhoneNumbersResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.ListPhoneNumbersResponse.wrap(buildAwsValue())
}
object ListPhoneNumbersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.ListPhoneNumbersResponse =
      zio.aws.chimesdkvoice.model.ListPhoneNumbersResponse(
        phoneNumbers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def phoneNumbers
        : Optional[List[zio.aws.chimesdkvoice.model.PhoneNumber.ReadOnly]]
    def nextToken: Optional[String]
    def getPhoneNumbers: ZIO[Any, AwsError, List[
      zio.aws.chimesdkvoice.model.PhoneNumber.ReadOnly
    ]] = AwsError.unwrapOptionField("phoneNumbers", phoneNumbers)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersResponse
  ) extends zio.aws.chimesdkvoice.model.ListPhoneNumbersResponse.ReadOnly {
    override val phoneNumbers
        : Optional[List[zio.aws.chimesdkvoice.model.PhoneNumber.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumbers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chimesdkvoice.model.PhoneNumber.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersResponse
  ): zio.aws.chimesdkvoice.model.ListPhoneNumbersResponse.ReadOnly =
    new Wrapper(impl)
}
