package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetSipMediaApplicationLoggingConfigurationResponse(
    sipMediaApplicationLoggingConfiguration: Optional[
      zio.aws.chimesdkvoice.model.SipMediaApplicationLoggingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationResponse = {
    import GetSipMediaApplicationLoggingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationResponse
      .builder()
      .optionallyWith(
        sipMediaApplicationLoggingConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.sipMediaApplicationLoggingConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationResponse
      .wrap(buildAwsValue())
}
object GetSipMediaApplicationLoggingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationResponse =
      zio.aws.chimesdkvoice.model
        .GetSipMediaApplicationLoggingConfigurationResponse(
          sipMediaApplicationLoggingConfiguration.map(value => value.asEditable)
        )
    def sipMediaApplicationLoggingConfiguration: Optional[
      zio.aws.chimesdkvoice.model.SipMediaApplicationLoggingConfiguration.ReadOnly
    ]
    def getSipMediaApplicationLoggingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkvoice.model.SipMediaApplicationLoggingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sipMediaApplicationLoggingConfiguration",
      sipMediaApplicationLoggingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationResponse
  ) extends zio.aws.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationResponse.ReadOnly {
    override val sipMediaApplicationLoggingConfiguration: Optional[
      zio.aws.chimesdkvoice.model.SipMediaApplicationLoggingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sipMediaApplicationLoggingConfiguration())
      .map(value =>
        zio.aws.chimesdkvoice.model.SipMediaApplicationLoggingConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationResponse
  ): zio.aws.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
