package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.SensitiveNonEmptyString
import scala.jdk.CollectionConverters._
final case class GetPhoneNumberRequest(phoneNumberId: SensitiveNonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberRequest = {
    import GetPhoneNumberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberRequest
      .builder()
      .phoneNumberId(
        SensitiveNonEmptyString.unwrap(phoneNumberId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.GetPhoneNumberRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.GetPhoneNumberRequest.wrap(buildAwsValue())
}
object GetPhoneNumberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.GetPhoneNumberRequest =
      zio.aws.chimesdkvoice.model.GetPhoneNumberRequest(phoneNumberId)
    def phoneNumberId: SensitiveNonEmptyString
    def getPhoneNumberId: ZIO[Any, Nothing, SensitiveNonEmptyString] =
      ZIO.succeed(phoneNumberId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberRequest
  ) extends zio.aws.chimesdkvoice.model.GetPhoneNumberRequest.ReadOnly {
    override val phoneNumberId: SensitiveNonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .SensitiveNonEmptyString(impl.phoneNumberId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberRequest
  ): zio.aws.chimesdkvoice.model.GetPhoneNumberRequest.ReadOnly = new Wrapper(
    impl
  )
}
