package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkvoice.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class DeleteVoiceConnectorTerminationRequest(
    voiceConnectorId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorTerminationRequest = {
    import DeleteVoiceConnectorTerminationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorTerminationRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.DeleteVoiceConnectorTerminationRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.DeleteVoiceConnectorTerminationRequest
      .wrap(buildAwsValue())
}
object DeleteVoiceConnectorTerminationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorTerminationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.DeleteVoiceConnectorTerminationRequest =
      zio.aws.chimesdkvoice.model
        .DeleteVoiceConnectorTerminationRequest(voiceConnectorId)
    def voiceConnectorId: NonEmptyString
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorTerminationRequest
  ) extends zio.aws.chimesdkvoice.model.DeleteVoiceConnectorTerminationRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString(impl.voiceConnectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorTerminationRequest
  ): zio.aws.chimesdkvoice.model.DeleteVoiceConnectorTerminationRequest.ReadOnly =
    new Wrapper(impl)
}
