package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateSipRuleResponse(
    sipRule: Optional[zio.aws.chimesdkvoice.model.SipRule] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.CreateSipRuleResponse = {
    import CreateSipRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.CreateSipRuleResponse
      .builder()
      .optionallyWith(sipRule.map(value => value.buildAwsValue()))(_.sipRule)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.CreateSipRuleResponse.ReadOnly =
    zio.aws.chimesdkvoice.model.CreateSipRuleResponse.wrap(buildAwsValue())
}
object CreateSipRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.CreateSipRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.CreateSipRuleResponse =
      zio.aws.chimesdkvoice.model
        .CreateSipRuleResponse(sipRule.map(value => value.asEditable))
    def sipRule: Optional[zio.aws.chimesdkvoice.model.SipRule.ReadOnly]
    def getSipRule
        : ZIO[Any, AwsError, zio.aws.chimesdkvoice.model.SipRule.ReadOnly] =
      AwsError.unwrapOptionField("sipRule", sipRule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreateSipRuleResponse
  ) extends zio.aws.chimesdkvoice.model.CreateSipRuleResponse.ReadOnly {
    override val sipRule
        : Optional[zio.aws.chimesdkvoice.model.SipRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sipRule())
        .map(value => zio.aws.chimesdkvoice.model.SipRule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreateSipRuleResponse
  ): zio.aws.chimesdkvoice.model.CreateSipRuleResponse.ReadOnly = new Wrapper(
    impl
  )
}
