package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.{
  SensitiveString,
  NonEmptyString,
  E164PhoneNumber
}
import scala.jdk.CollectionConverters._
final case class CreateSipMediaApplicationCallRequest(
    fromPhoneNumber: E164PhoneNumber,
    toPhoneNumber: E164PhoneNumber,
    sipMediaApplicationId: NonEmptyString,
    sipHeaders: Optional[Map[SensitiveString, SensitiveString]] =
      Optional.Absent,
    argumentsMap: Optional[Map[SensitiveString, SensitiveString]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationCallRequest = {
    import CreateSipMediaApplicationCallRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationCallRequest
      .builder()
      .fromPhoneNumber(
        E164PhoneNumber.unwrap(fromPhoneNumber): java.lang.String
      )
      .toPhoneNumber(E164PhoneNumber.unwrap(toPhoneNumber): java.lang.String)
      .sipMediaApplicationId(
        NonEmptyString.unwrap(sipMediaApplicationId): java.lang.String
      )
      .optionallyWith(
        sipHeaders.map(value =>
          value
            .map({ case (key, value) =>
              (SensitiveString
                .unwrap(key): java.lang.String) -> (SensitiveString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.sipHeaders)
      .optionallyWith(
        argumentsMap.map(value =>
          value
            .map({ case (key, value) =>
              (SensitiveString
                .unwrap(key): java.lang.String) -> (SensitiveString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.argumentsMap)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkvoice.model.CreateSipMediaApplicationCallRequest.ReadOnly =
    zio.aws.chimesdkvoice.model.CreateSipMediaApplicationCallRequest
      .wrap(buildAwsValue())
}
object CreateSipMediaApplicationCallRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationCallRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkvoice.model.CreateSipMediaApplicationCallRequest =
      zio.aws.chimesdkvoice.model.CreateSipMediaApplicationCallRequest(
        fromPhoneNumber,
        toPhoneNumber,
        sipMediaApplicationId,
        sipHeaders.map(value => value),
        argumentsMap.map(value => value)
      )
    def fromPhoneNumber: E164PhoneNumber
    def toPhoneNumber: E164PhoneNumber
    def sipMediaApplicationId: NonEmptyString
    def sipHeaders: Optional[Map[SensitiveString, SensitiveString]]
    def argumentsMap: Optional[Map[SensitiveString, SensitiveString]]
    def getFromPhoneNumber: ZIO[Any, Nothing, E164PhoneNumber] =
      ZIO.succeed(fromPhoneNumber)
    def getToPhoneNumber: ZIO[Any, Nothing, E164PhoneNumber] =
      ZIO.succeed(toPhoneNumber)
    def getSipMediaApplicationId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(sipMediaApplicationId)
    def getSipHeaders
        : ZIO[Any, AwsError, Map[SensitiveString, SensitiveString]] =
      AwsError.unwrapOptionField("sipHeaders", sipHeaders)
    def getArgumentsMap
        : ZIO[Any, AwsError, Map[SensitiveString, SensitiveString]] =
      AwsError.unwrapOptionField("argumentsMap", argumentsMap)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationCallRequest
  ) extends zio.aws.chimesdkvoice.model.CreateSipMediaApplicationCallRequest.ReadOnly {
    override val fromPhoneNumber: E164PhoneNumber =
      zio.aws.chimesdkvoice.model.primitives
        .E164PhoneNumber(impl.fromPhoneNumber())
    override val toPhoneNumber: E164PhoneNumber =
      zio.aws.chimesdkvoice.model.primitives
        .E164PhoneNumber(impl.toPhoneNumber())
    override val sipMediaApplicationId: NonEmptyString =
      zio.aws.chimesdkvoice.model.primitives
        .NonEmptyString(impl.sipMediaApplicationId())
    override val sipHeaders: Optional[Map[SensitiveString, SensitiveString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sipHeaders())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.chimesdkvoice.model.primitives.SensitiveString(
                key
              ) -> zio.aws.chimesdkvoice.model.primitives.SensitiveString(value)
            })
            .toMap
        )
    override val argumentsMap: Optional[Map[SensitiveString, SensitiveString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.argumentsMap())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.chimesdkvoice.model.primitives.SensitiveString(
                key
              ) -> zio.aws.chimesdkvoice.model.primitives.SensitiveString(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationCallRequest
  ): zio.aws.chimesdkvoice.model.CreateSipMediaApplicationCallRequest.ReadOnly =
    new Wrapper(impl)
}
