package zio.aws.chimesdkvoice.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkvoice.model.primitives.SensitiveNonEmptyString
import scala.jdk.CollectionConverters._
final case class Address(
    streetName: Optional[SensitiveNonEmptyString] = Optional.Absent,
    streetSuffix: Optional[SensitiveNonEmptyString] = Optional.Absent,
    postDirectional: Optional[SensitiveNonEmptyString] = Optional.Absent,
    preDirectional: Optional[SensitiveNonEmptyString] = Optional.Absent,
    streetNumber: Optional[SensitiveNonEmptyString] = Optional.Absent,
    city: Optional[SensitiveNonEmptyString] = Optional.Absent,
    state: Optional[SensitiveNonEmptyString] = Optional.Absent,
    postalCode: Optional[SensitiveNonEmptyString] = Optional.Absent,
    postalCodePlus4: Optional[SensitiveNonEmptyString] = Optional.Absent,
    country: Optional[SensitiveNonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkvoice.model.Address = {
    import Address.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkvoice.model.Address
      .builder()
      .optionallyWith(
        streetName.map(value =>
          SensitiveNonEmptyString.unwrap(value): java.lang.String
        )
      )(_.streetName)
      .optionallyWith(
        streetSuffix.map(value =>
          SensitiveNonEmptyString.unwrap(value): java.lang.String
        )
      )(_.streetSuffix)
      .optionallyWith(
        postDirectional.map(value =>
          SensitiveNonEmptyString.unwrap(value): java.lang.String
        )
      )(_.postDirectional)
      .optionallyWith(
        preDirectional.map(value =>
          SensitiveNonEmptyString.unwrap(value): java.lang.String
        )
      )(_.preDirectional)
      .optionallyWith(
        streetNumber.map(value =>
          SensitiveNonEmptyString.unwrap(value): java.lang.String
        )
      )(_.streetNumber)
      .optionallyWith(
        city.map(value =>
          SensitiveNonEmptyString.unwrap(value): java.lang.String
        )
      )(_.city)
      .optionallyWith(
        state.map(value =>
          SensitiveNonEmptyString.unwrap(value): java.lang.String
        )
      )(_.state)
      .optionallyWith(
        postalCode.map(value =>
          SensitiveNonEmptyString.unwrap(value): java.lang.String
        )
      )(_.postalCode)
      .optionallyWith(
        postalCodePlus4.map(value =>
          SensitiveNonEmptyString.unwrap(value): java.lang.String
        )
      )(_.postalCodePlus4)
      .optionallyWith(
        country.map(value =>
          SensitiveNonEmptyString.unwrap(value): java.lang.String
        )
      )(_.country)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkvoice.model.Address.ReadOnly =
    zio.aws.chimesdkvoice.model.Address.wrap(buildAwsValue())
}
object Address {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkvoice.model.Address
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkvoice.model.Address =
      zio.aws.chimesdkvoice.model.Address(
        streetName.map(value => value),
        streetSuffix.map(value => value),
        postDirectional.map(value => value),
        preDirectional.map(value => value),
        streetNumber.map(value => value),
        city.map(value => value),
        state.map(value => value),
        postalCode.map(value => value),
        postalCodePlus4.map(value => value),
        country.map(value => value)
      )
    def streetName: Optional[SensitiveNonEmptyString]
    def streetSuffix: Optional[SensitiveNonEmptyString]
    def postDirectional: Optional[SensitiveNonEmptyString]
    def preDirectional: Optional[SensitiveNonEmptyString]
    def streetNumber: Optional[SensitiveNonEmptyString]
    def city: Optional[SensitiveNonEmptyString]
    def state: Optional[SensitiveNonEmptyString]
    def postalCode: Optional[SensitiveNonEmptyString]
    def postalCodePlus4: Optional[SensitiveNonEmptyString]
    def country: Optional[SensitiveNonEmptyString]
    def getStreetName: ZIO[Any, AwsError, SensitiveNonEmptyString] =
      AwsError.unwrapOptionField("streetName", streetName)
    def getStreetSuffix: ZIO[Any, AwsError, SensitiveNonEmptyString] =
      AwsError.unwrapOptionField("streetSuffix", streetSuffix)
    def getPostDirectional: ZIO[Any, AwsError, SensitiveNonEmptyString] =
      AwsError.unwrapOptionField("postDirectional", postDirectional)
    def getPreDirectional: ZIO[Any, AwsError, SensitiveNonEmptyString] =
      AwsError.unwrapOptionField("preDirectional", preDirectional)
    def getStreetNumber: ZIO[Any, AwsError, SensitiveNonEmptyString] =
      AwsError.unwrapOptionField("streetNumber", streetNumber)
    def getCity: ZIO[Any, AwsError, SensitiveNonEmptyString] =
      AwsError.unwrapOptionField("city", city)
    def getState: ZIO[Any, AwsError, SensitiveNonEmptyString] =
      AwsError.unwrapOptionField("state", state)
    def getPostalCode: ZIO[Any, AwsError, SensitiveNonEmptyString] =
      AwsError.unwrapOptionField("postalCode", postalCode)
    def getPostalCodePlus4: ZIO[Any, AwsError, SensitiveNonEmptyString] =
      AwsError.unwrapOptionField("postalCodePlus4", postalCodePlus4)
    def getCountry: ZIO[Any, AwsError, SensitiveNonEmptyString] =
      AwsError.unwrapOptionField("country", country)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.Address
  ) extends zio.aws.chimesdkvoice.model.Address.ReadOnly {
    override val streetName: Optional[SensitiveNonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streetName())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.SensitiveNonEmptyString(value)
        )
    override val streetSuffix: Optional[SensitiveNonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streetSuffix())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.SensitiveNonEmptyString(value)
        )
    override val postDirectional: Optional[SensitiveNonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.postDirectional())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.SensitiveNonEmptyString(value)
        )
    override val preDirectional: Optional[SensitiveNonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preDirectional())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.SensitiveNonEmptyString(value)
        )
    override val streetNumber: Optional[SensitiveNonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streetNumber())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.SensitiveNonEmptyString(value)
        )
    override val city: Optional[SensitiveNonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.city())
      .map(value =>
        zio.aws.chimesdkvoice.model.primitives.SensitiveNonEmptyString(value)
      )
    override val state: Optional[SensitiveNonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.SensitiveNonEmptyString(value)
        )
    override val postalCode: Optional[SensitiveNonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.postalCode())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.SensitiveNonEmptyString(value)
        )
    override val postalCodePlus4: Optional[SensitiveNonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.postalCodePlus4())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.SensitiveNonEmptyString(value)
        )
    override val country: Optional[SensitiveNonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.country())
        .map(value =>
          zio.aws.chimesdkvoice.model.primitives.SensitiveNonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkvoice.model.Address
  ): zio.aws.chimesdkvoice.model.Address.ReadOnly = new Wrapper(impl)
}
