package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceARN: ChimeArn,
    tags: Iterable[zio.aws.chimesdkmessaging.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.TagResourceRequest
      .builder()
      .resourceARN(ChimeArn.unwrap(resourceARN): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmessaging.model.TagResourceRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.TagResourceRequest =
      zio.aws.chimesdkmessaging.model.TagResourceRequest(
        resourceARN,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceARN: ChimeArn
    def tags: List[zio.aws.chimesdkmessaging.model.Tag.ReadOnly]
    def getResourceARN: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(resourceARN)
    def getTags: ZIO[Any, Nothing, List[
      zio.aws.chimesdkmessaging.model.Tag.ReadOnly
    ]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.TagResourceRequest
  ) extends zio.aws.chimesdkmessaging.model.TagResourceRequest.ReadOnly {
    override val resourceARN: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.resourceARN())
    override val tags: List[zio.aws.chimesdkmessaging.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.chimesdkmessaging.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.TagResourceRequest
  ): zio.aws.chimesdkmessaging.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
