package zio.aws.chimesdkmessaging.model
import scala.jdk.CollectionConverters._
sealed trait MessagingDataType {
  def unwrap: software.amazon.awssdk.services.chimesdkmessaging.model.MessagingDataType
}
object MessagingDataType {
  def wrap(
      value: software.amazon.awssdk.services.chimesdkmessaging.model.MessagingDataType
  ): zio.aws.chimesdkmessaging.model.MessagingDataType = value match {
    case software.amazon.awssdk.services.chimesdkmessaging.model.MessagingDataType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chimesdkmessaging.model.MessagingDataType.CHANNEL =>
      val r = Channel
      r
    case software.amazon.awssdk.services.chimesdkmessaging.model.MessagingDataType.CHANNEL_MESSAGE =>
      val r = ChannelMessage
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chimesdkmessaging.model.MessagingDataType {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.MessagingDataType =
      software.amazon.awssdk.services.chimesdkmessaging.model.MessagingDataType.UNKNOWN_TO_SDK_VERSION
  }
  case object Channel
      extends zio.aws.chimesdkmessaging.model.MessagingDataType {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.MessagingDataType =
      software.amazon.awssdk.services.chimesdkmessaging.model.MessagingDataType.CHANNEL
  }
  case object ChannelMessage
      extends zio.aws.chimesdkmessaging.model.MessagingDataType {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.MessagingDataType =
      software.amazon.awssdk.services.chimesdkmessaging.model.MessagingDataType.CHANNEL_MESSAGE
  }
}
