package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class GetMessagingStreamingConfigurationsRequest(
    appInstanceArn: ChimeArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.GetMessagingStreamingConfigurationsRequest = {
    import GetMessagingStreamingConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.GetMessagingStreamingConfigurationsRequest
      .builder()
      .appInstanceArn(ChimeArn.unwrap(appInstanceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.GetMessagingStreamingConfigurationsRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.GetMessagingStreamingConfigurationsRequest
      .wrap(buildAwsValue())
}
object GetMessagingStreamingConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.GetMessagingStreamingConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.GetMessagingStreamingConfigurationsRequest =
      zio.aws.chimesdkmessaging.model
        .GetMessagingStreamingConfigurationsRequest(appInstanceArn)
    def appInstanceArn: ChimeArn
    def getAppInstanceArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(appInstanceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.GetMessagingStreamingConfigurationsRequest
  ) extends zio.aws.chimesdkmessaging.model.GetMessagingStreamingConfigurationsRequest.ReadOnly {
    override val appInstanceArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.appInstanceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.GetMessagingStreamingConfigurationsRequest
  ): zio.aws.chimesdkmessaging.model.GetMessagingStreamingConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
