package zio.aws.chimesdkmessaging
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.chimesdkmessaging.model.primitives.{
  MessageAttributeName,
  ChimeArn,
  MessageAttributeStringValue,
  SearchFieldValue,
  TagKey
}
import zio.aws.chimesdkmessaging.model.primitives.ContentType.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object CallbackIdType extends Subtype[String]
    type CallbackIdType =
      zio.aws.chimesdkmessaging.model.primitives.CallbackIdType.Type
    object ChannelFlowExecutionOrder extends Subtype[Int]
    type ChannelFlowExecutionOrder =
      zio.aws.chimesdkmessaging.model.primitives.ChannelFlowExecutionOrder.Type
    object ChannelId extends Subtype[String]
    type ChannelId = zio.aws.chimesdkmessaging.model.primitives.ChannelId.Type
    object ChimeArn extends Subtype[String]
    type ChimeArn = zio.aws.chimesdkmessaging.model.primitives.ChimeArn.Type
    object ClientRequestToken extends Subtype[String]
    type ClientRequestToken =
      zio.aws.chimesdkmessaging.model.primitives.ClientRequestToken.Type
    object Content extends Subtype[String]
    type Content = zio.aws.chimesdkmessaging.model.primitives.Content.Type
    object ContentType extends Subtype[String]
    type ContentType =
      zio.aws.chimesdkmessaging.model.primitives.ContentType.Type
    object ExpirationDays extends Subtype[Int]
    type ExpirationDays =
      zio.aws.chimesdkmessaging.model.primitives.ExpirationDays.Type
    object FilterRule extends Subtype[String]
    type FilterRule = zio.aws.chimesdkmessaging.model.primitives.FilterRule.Type
    object LambdaFunctionArn extends Subtype[String]
    type LambdaFunctionArn =
      zio.aws.chimesdkmessaging.model.primitives.LambdaFunctionArn.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.chimesdkmessaging.model.primitives.MaxResults.Type
    object MaximumSubChannels extends Subtype[Int]
    type MaximumSubChannels =
      zio.aws.chimesdkmessaging.model.primitives.MaximumSubChannels.Type
    object MembershipCount extends Subtype[Int]
    type MembershipCount =
      zio.aws.chimesdkmessaging.model.primitives.MembershipCount.Type
    object MessageAttributeName extends Subtype[String]
    type MessageAttributeName =
      zio.aws.chimesdkmessaging.model.primitives.MessageAttributeName.Type
    object MessageAttributeStringValue extends Subtype[String]
    type MessageAttributeStringValue =
      zio.aws.chimesdkmessaging.model.primitives.MessageAttributeStringValue.Type
    object MessageId extends Subtype[String]
    type MessageId = zio.aws.chimesdkmessaging.model.primitives.MessageId.Type
    object Metadata extends Subtype[String]
    type Metadata = zio.aws.chimesdkmessaging.model.primitives.Metadata.Type
    object MinimumMembershipPercentage extends Subtype[Int]
    type MinimumMembershipPercentage =
      zio.aws.chimesdkmessaging.model.primitives.MinimumMembershipPercentage.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.chimesdkmessaging.model.primitives.NextToken.Type
    object NonEmptyContent extends Subtype[String]
    type NonEmptyContent =
      zio.aws.chimesdkmessaging.model.primitives.NonEmptyContent.Type
    object NonEmptyResourceName extends Subtype[String]
    type NonEmptyResourceName =
      zio.aws.chimesdkmessaging.model.primitives.NonEmptyResourceName.Type
    object NonNullableBoolean extends Subtype[Boolean]
    type NonNullableBoolean =
      zio.aws.chimesdkmessaging.model.primitives.NonNullableBoolean.Type
    object PushNotificationBody extends Subtype[String]
    type PushNotificationBody =
      zio.aws.chimesdkmessaging.model.primitives.PushNotificationBody.Type
    object PushNotificationTitle extends Subtype[String]
    type PushNotificationTitle =
      zio.aws.chimesdkmessaging.model.primitives.PushNotificationTitle.Type
    object ResourceName extends Subtype[String]
    type ResourceName =
      zio.aws.chimesdkmessaging.model.primitives.ResourceName.Type
    object SearchFieldValue extends Subtype[String]
    type SearchFieldValue =
      zio.aws.chimesdkmessaging.model.primitives.SearchFieldValue.Type
    object StatusDetail extends Subtype[String]
    type StatusDetail =
      zio.aws.chimesdkmessaging.model.primitives.StatusDetail.Type
    object SubChannelId extends Subtype[String]
    type SubChannelId =
      zio.aws.chimesdkmessaging.model.primitives.SubChannelId.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.chimesdkmessaging.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.chimesdkmessaging.model.primitives.TagValue.Type
    object TargetMembershipsPerSubChannel extends Subtype[Int]
    type TargetMembershipsPerSubChannel =
      zio.aws.chimesdkmessaging.model.primitives.TargetMembershipsPerSubChannel.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.chimesdkmessaging.model.primitives.Timestamp.Type
    object UrlType extends Subtype[String]
    type UrlType = zio.aws.chimesdkmessaging.model.primitives.UrlType.Type
  }
  type BatchCreateChannelMembershipErrors =
    List[zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipError]
  type ChannelAssociatedWithFlowSummaryList =
    List[zio.aws.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary]
  type ChannelBanSummaryList =
    List[zio.aws.chimesdkmessaging.model.ChannelBanSummary]
  type ChannelFlowSummaryList =
    List[zio.aws.chimesdkmessaging.model.ChannelFlowSummary]
  type ChannelMemberArns = List[ChimeArn]
  type ChannelMembershipForAppInstanceUserSummaryList = List[
    zio.aws.chimesdkmessaging.model.ChannelMembershipForAppInstanceUserSummary
  ]
  type ChannelMembershipSummaryList =
    List[zio.aws.chimesdkmessaging.model.ChannelMembershipSummary]
  type ChannelMessageSummaryList =
    List[zio.aws.chimesdkmessaging.model.ChannelMessageSummary]
  type ChannelModeratedByAppInstanceUserSummaryList = List[
    zio.aws.chimesdkmessaging.model.ChannelModeratedByAppInstanceUserSummary
  ]
  type ChannelModeratorArns = List[ChimeArn]
  type ChannelModeratorSummaryList =
    List[zio.aws.chimesdkmessaging.model.ChannelModeratorSummary]
  type ChannelSummaryList = List[zio.aws.chimesdkmessaging.model.ChannelSummary]
  type MemberArns = List[ChimeArn]
  type Members = List[zio.aws.chimesdkmessaging.model.Identity]
  type MessageAttributeMap = Map[
    MessageAttributeName,
    zio.aws.chimesdkmessaging.model.MessageAttributeValue
  ]
  type MessageAttributeStringValues = List[MessageAttributeStringValue]
  type ProcessorList = List[zio.aws.chimesdkmessaging.model.Processor]
  type SearchFieldValues = List[SearchFieldValue]
  type SearchFields = List[zio.aws.chimesdkmessaging.model.SearchField]
  type StreamingConfigurationList =
    List[zio.aws.chimesdkmessaging.model.StreamingConfiguration]
  type SubChannelSummaryList =
    List[zio.aws.chimesdkmessaging.model.SubChannelSummary]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.chimesdkmessaging.model.Tag]
  type TargetList = List[zio.aws.chimesdkmessaging.model.Target]
}
