package zio.aws.chimesdkmessaging.model
import zio.aws.chimesdkmessaging.model.primitives.{
  MembershipCount,
  SubChannelId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SubChannelSummary(
    subChannelId: Optional[SubChannelId] = Optional.Absent,
    membershipCount: Optional[MembershipCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.SubChannelSummary = {
    import SubChannelSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.SubChannelSummary
      .builder()
      .optionallyWith(
        subChannelId.map(value => SubChannelId.unwrap(value): java.lang.String)
      )(_.subChannelId)
      .optionallyWith(
        membershipCount.map(value => MembershipCount.unwrap(value): Integer)
      )(_.membershipCount)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmessaging.model.SubChannelSummary.ReadOnly =
    zio.aws.chimesdkmessaging.model.SubChannelSummary.wrap(buildAwsValue())
}
object SubChannelSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.SubChannelSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.SubChannelSummary =
      zio.aws.chimesdkmessaging.model.SubChannelSummary(
        subChannelId.map(value => value),
        membershipCount.map(value => value)
      )
    def subChannelId: Optional[SubChannelId]
    def membershipCount: Optional[MembershipCount]
    def getSubChannelId: ZIO[Any, AwsError, SubChannelId] =
      AwsError.unwrapOptionField("subChannelId", subChannelId)
    def getMembershipCount: ZIO[Any, AwsError, MembershipCount] =
      AwsError.unwrapOptionField("membershipCount", membershipCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.SubChannelSummary
  ) extends zio.aws.chimesdkmessaging.model.SubChannelSummary.ReadOnly {
    override val subChannelId: Optional[SubChannelId] = zio.aws.core.internal
      .optionalFromNullable(impl.subChannelId())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.SubChannelId(value)
      )
    override val membershipCount: Optional[MembershipCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.membershipCount())
        .map(value =>
          zio.aws.chimesdkmessaging.model.primitives.MembershipCount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.SubChannelSummary
  ): zio.aws.chimesdkmessaging.model.SubChannelSummary.ReadOnly = new Wrapper(
    impl
  )
}
