package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.{SubChannelId, ChimeArn}
import scala.jdk.CollectionConverters._
final case class BatchChannelMemberships(
    invitedBy: Optional[zio.aws.chimesdkmessaging.model.Identity] =
      Optional.Absent,
    `type`: Optional[zio.aws.chimesdkmessaging.model.ChannelMembershipType] =
      Optional.Absent,
    members: Optional[Iterable[zio.aws.chimesdkmessaging.model.Identity]] =
      Optional.Absent,
    channelArn: Optional[ChimeArn] = Optional.Absent,
    subChannelId: Optional[SubChannelId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.BatchChannelMemberships = {
    import BatchChannelMemberships.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.BatchChannelMemberships
      .builder()
      .optionallyWith(invitedBy.map(value => value.buildAwsValue()))(
        _.invitedBy
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        members.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.members)
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        subChannelId.map(value => SubChannelId.unwrap(value): java.lang.String)
      )(_.subChannelId)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.BatchChannelMemberships.ReadOnly =
    zio.aws.chimesdkmessaging.model.BatchChannelMemberships
      .wrap(buildAwsValue())
}
object BatchChannelMemberships {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.BatchChannelMemberships
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.BatchChannelMemberships =
      zio.aws.chimesdkmessaging.model.BatchChannelMemberships(
        invitedBy.map(value => value.asEditable),
        `type`.map(value => value),
        members.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        channelArn.map(value => value),
        subChannelId.map(value => value)
      )
    def invitedBy: Optional[zio.aws.chimesdkmessaging.model.Identity.ReadOnly]
    def `type`: Optional[zio.aws.chimesdkmessaging.model.ChannelMembershipType]
    def members
        : Optional[List[zio.aws.chimesdkmessaging.model.Identity.ReadOnly]]
    def channelArn: Optional[ChimeArn]
    def subChannelId: Optional[SubChannelId]
    def getInvitedBy: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.Identity.ReadOnly
    ] = AwsError.unwrapOptionField("invitedBy", invitedBy)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelMembershipType
    ] = AwsError.unwrapOptionField("type", `type`)
    def getMembers: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmessaging.model.Identity.ReadOnly
    ]] = AwsError.unwrapOptionField("members", members)
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getSubChannelId: ZIO[Any, AwsError, SubChannelId] =
      AwsError.unwrapOptionField("subChannelId", subChannelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.BatchChannelMemberships
  ) extends zio.aws.chimesdkmessaging.model.BatchChannelMemberships.ReadOnly {
    override val invitedBy
        : Optional[zio.aws.chimesdkmessaging.model.Identity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invitedBy())
        .map(value => zio.aws.chimesdkmessaging.model.Identity.wrap(value))
    override val `type`
        : Optional[zio.aws.chimesdkmessaging.model.ChannelMembershipType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.chimesdkmessaging.model.ChannelMembershipType.wrap(value)
        )
    override val members
        : Optional[List[zio.aws.chimesdkmessaging.model.Identity.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.members())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chimesdkmessaging.model.Identity.wrap(item)
          }.toList
        )
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val subChannelId: Optional[SubChannelId] = zio.aws.core.internal
      .optionalFromNullable(impl.subChannelId())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.SubChannelId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.BatchChannelMemberships
  ): zio.aws.chimesdkmessaging.model.BatchChannelMemberships.ReadOnly =
    new Wrapper(impl)
}
