package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class PutMessagingStreamingConfigurationsRequest(
    appInstanceArn: ChimeArn,
    streamingConfigurations: Iterable[
      zio.aws.chimesdkmessaging.model.StreamingConfiguration
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.PutMessagingStreamingConfigurationsRequest = {
    import PutMessagingStreamingConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.PutMessagingStreamingConfigurationsRequest
      .builder()
      .appInstanceArn(ChimeArn.unwrap(appInstanceArn): java.lang.String)
      .streamingConfigurations(streamingConfigurations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.PutMessagingStreamingConfigurationsRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.PutMessagingStreamingConfigurationsRequest
      .wrap(buildAwsValue())
}
object PutMessagingStreamingConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.PutMessagingStreamingConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.PutMessagingStreamingConfigurationsRequest =
      zio.aws.chimesdkmessaging.model
        .PutMessagingStreamingConfigurationsRequest(
          appInstanceArn,
          streamingConfigurations.map { item =>
            item.asEditable
          }
        )
    def appInstanceArn: ChimeArn
    def streamingConfigurations
        : List[zio.aws.chimesdkmessaging.model.StreamingConfiguration.ReadOnly]
    def getAppInstanceArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(appInstanceArn)
    def getStreamingConfigurations: ZIO[Any, Nothing, List[
      zio.aws.chimesdkmessaging.model.StreamingConfiguration.ReadOnly
    ]] = ZIO.succeed(streamingConfigurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.PutMessagingStreamingConfigurationsRequest
  ) extends zio.aws.chimesdkmessaging.model.PutMessagingStreamingConfigurationsRequest.ReadOnly {
    override val appInstanceArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.appInstanceArn())
    override val streamingConfigurations: List[
      zio.aws.chimesdkmessaging.model.StreamingConfiguration.ReadOnly
    ] = impl
      .streamingConfigurations()
      .asScala
      .map { item =>
        zio.aws.chimesdkmessaging.model.StreamingConfiguration.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.PutMessagingStreamingConfigurationsRequest
  ): zio.aws.chimesdkmessaging.model.PutMessagingStreamingConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
