package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.{
  SubChannelId,
  MessageId,
  ChimeArn
}
import scala.jdk.CollectionConverters._
final case class GetChannelMessageRequest(
    channelArn: ChimeArn,
    messageId: MessageId,
    chimeBearer: ChimeArn,
    subChannelId: Optional[SubChannelId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.GetChannelMessageRequest = {
    import GetChannelMessageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.GetChannelMessageRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .messageId(MessageId.unwrap(messageId): java.lang.String)
      .chimeBearer(ChimeArn.unwrap(chimeBearer): java.lang.String)
      .optionallyWith(
        subChannelId.map(value => SubChannelId.unwrap(value): java.lang.String)
      )(_.subChannelId)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.GetChannelMessageRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.GetChannelMessageRequest
      .wrap(buildAwsValue())
}
object GetChannelMessageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.GetChannelMessageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.GetChannelMessageRequest =
      zio.aws.chimesdkmessaging.model.GetChannelMessageRequest(
        channelArn,
        messageId,
        chimeBearer,
        subChannelId.map(value => value)
      )
    def channelArn: ChimeArn
    def messageId: MessageId
    def chimeBearer: ChimeArn
    def subChannelId: Optional[SubChannelId]
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getMessageId: ZIO[Any, Nothing, MessageId] = ZIO.succeed(messageId)
    def getChimeBearer: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(chimeBearer)
    def getSubChannelId: ZIO[Any, AwsError, SubChannelId] =
      AwsError.unwrapOptionField("subChannelId", subChannelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.GetChannelMessageRequest
  ) extends zio.aws.chimesdkmessaging.model.GetChannelMessageRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelArn())
    override val messageId: MessageId =
      zio.aws.chimesdkmessaging.model.primitives.MessageId(impl.messageId())
    override val chimeBearer: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.chimeBearer())
    override val subChannelId: Optional[SubChannelId] = zio.aws.core.internal
      .optionalFromNullable(impl.subChannelId())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.SubChannelId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.GetChannelMessageRequest
  ): zio.aws.chimesdkmessaging.model.GetChannelMessageRequest.ReadOnly =
    new Wrapper(impl)
}
