package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class Target(memberArn: Optional[ChimeArn] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.Target = {
    import Target.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.Target
      .builder()
      .optionallyWith(
        memberArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.memberArn)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmessaging.model.Target.ReadOnly =
    zio.aws.chimesdkmessaging.model.Target.wrap(buildAwsValue())
}
object Target {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.Target
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.Target =
      zio.aws.chimesdkmessaging.model.Target(memberArn.map(value => value))
    def memberArn: Optional[ChimeArn]
    def getMemberArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("memberArn", memberArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.Target
  ) extends zio.aws.chimesdkmessaging.model.Target.ReadOnly {
    override val memberArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.memberArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.Target
  ): zio.aws.chimesdkmessaging.model.Target.ReadOnly = new Wrapper(impl)
}
