package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.{
  ContentType,
  MessageAttributeName,
  ChimeArn,
  NonEmptyContent,
  ClientRequestToken,
  SubChannelId,
  Metadata
}
import scala.jdk.CollectionConverters._
final case class SendChannelMessageRequest(
    channelArn: ChimeArn,
    content: NonEmptyContent,
    `type`: zio.aws.chimesdkmessaging.model.ChannelMessageType,
    persistence: zio.aws.chimesdkmessaging.model.ChannelMessagePersistenceType,
    metadata: Optional[Metadata] = Optional.Absent,
    clientRequestToken: ClientRequestToken,
    chimeBearer: ChimeArn,
    pushNotification: Optional[
      zio.aws.chimesdkmessaging.model.PushNotificationConfiguration
    ] = Optional.Absent,
    messageAttributes: Optional[Map[
      MessageAttributeName,
      zio.aws.chimesdkmessaging.model.MessageAttributeValue
    ]] = Optional.Absent,
    subChannelId: Optional[SubChannelId] = Optional.Absent,
    contentType: Optional[ContentType] = Optional.Absent,
    target: Optional[Iterable[zio.aws.chimesdkmessaging.model.Target]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.SendChannelMessageRequest = {
    import SendChannelMessageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.SendChannelMessageRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .content(NonEmptyContent.unwrap(content): java.lang.String)
      .`type`(`type`.unwrap)
      .persistence(persistence.unwrap)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .clientRequestToken(
        ClientRequestToken.unwrap(clientRequestToken): java.lang.String
      )
      .chimeBearer(ChimeArn.unwrap(chimeBearer): java.lang.String)
      .optionallyWith(pushNotification.map(value => value.buildAwsValue()))(
        _.pushNotification
      )
      .optionallyWith(
        messageAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (MessageAttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.messageAttributes)
      .optionallyWith(
        subChannelId.map(value => SubChannelId.unwrap(value): java.lang.String)
      )(_.subChannelId)
      .optionallyWith(
        contentType.map(value => ContentType.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(
        target.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.target)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.SendChannelMessageRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.SendChannelMessageRequest
      .wrap(buildAwsValue())
}
object SendChannelMessageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.SendChannelMessageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.SendChannelMessageRequest =
      zio.aws.chimesdkmessaging.model.SendChannelMessageRequest(
        channelArn,
        content,
        `type`,
        persistence,
        metadata.map(value => value),
        clientRequestToken,
        chimeBearer,
        pushNotification.map(value => value.asEditable),
        messageAttributes.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        subChannelId.map(value => value),
        contentType.map(value => value),
        target.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def channelArn: ChimeArn
    def content: NonEmptyContent
    def `type`: zio.aws.chimesdkmessaging.model.ChannelMessageType
    def persistence
        : zio.aws.chimesdkmessaging.model.ChannelMessagePersistenceType
    def metadata: Optional[Metadata]
    def clientRequestToken: ClientRequestToken
    def chimeBearer: ChimeArn
    def pushNotification: Optional[
      zio.aws.chimesdkmessaging.model.PushNotificationConfiguration.ReadOnly
    ]
    def messageAttributes: Optional[Map[
      MessageAttributeName,
      zio.aws.chimesdkmessaging.model.MessageAttributeValue.ReadOnly
    ]]
    def subChannelId: Optional[SubChannelId]
    def contentType: Optional[ContentType]
    def target: Optional[List[zio.aws.chimesdkmessaging.model.Target.ReadOnly]]
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getContent: ZIO[Any, Nothing, NonEmptyContent] = ZIO.succeed(content)
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmessaging.model.ChannelMessageType
    ] = ZIO.succeed(`type`)
    def getPersistence: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmessaging.model.ChannelMessagePersistenceType
    ] = ZIO.succeed(persistence)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestToken] =
      ZIO.succeed(clientRequestToken)
    def getChimeBearer: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(chimeBearer)
    def getPushNotification: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.PushNotificationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("pushNotification", pushNotification)
    def getMessageAttributes: ZIO[Any, AwsError, Map[
      MessageAttributeName,
      zio.aws.chimesdkmessaging.model.MessageAttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("messageAttributes", messageAttributes)
    def getSubChannelId: ZIO[Any, AwsError, SubChannelId] =
      AwsError.unwrapOptionField("subChannelId", subChannelId)
    def getContentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getTarget: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmessaging.model.Target.ReadOnly
    ]] = AwsError.unwrapOptionField("target", target)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.SendChannelMessageRequest
  ) extends zio.aws.chimesdkmessaging.model.SendChannelMessageRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelArn())
    override val content: NonEmptyContent =
      zio.aws.chimesdkmessaging.model.primitives.NonEmptyContent(impl.content())
    override val `type`: zio.aws.chimesdkmessaging.model.ChannelMessageType =
      zio.aws.chimesdkmessaging.model.ChannelMessageType.wrap(impl.`type`())
    override val persistence
        : zio.aws.chimesdkmessaging.model.ChannelMessagePersistenceType =
      zio.aws.chimesdkmessaging.model.ChannelMessagePersistenceType
        .wrap(impl.persistence())
    override val metadata: Optional[Metadata] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Metadata(value))
    override val clientRequestToken: ClientRequestToken =
      zio.aws.chimesdkmessaging.model.primitives
        .ClientRequestToken(impl.clientRequestToken())
    override val chimeBearer: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.chimeBearer())
    override val pushNotification: Optional[
      zio.aws.chimesdkmessaging.model.PushNotificationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.pushNotification())
      .map(value =>
        zio.aws.chimesdkmessaging.model.PushNotificationConfiguration
          .wrap(value)
      )
    override val messageAttributes: Optional[Map[
      MessageAttributeName,
      zio.aws.chimesdkmessaging.model.MessageAttributeValue.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.messageAttributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.chimesdkmessaging.model.primitives.MessageAttributeName(
              key
            ) -> zio.aws.chimesdkmessaging.model.MessageAttributeValue
              .wrap(value)
          })
          .toMap
      )
    override val subChannelId: Optional[SubChannelId] = zio.aws.core.internal
      .optionalFromNullable(impl.subChannelId())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.SubChannelId(value)
      )
    override val contentType: Optional[ContentType] = zio.aws.core.internal
      .optionalFromNullable(impl.contentType())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.ContentType(value)
      )
    override val target
        : Optional[List[zio.aws.chimesdkmessaging.model.Target.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.target())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chimesdkmessaging.model.Target.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.SendChannelMessageRequest
  ): zio.aws.chimesdkmessaging.model.SendChannelMessageRequest.ReadOnly =
    new Wrapper(impl)
}
