package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class PutChannelExpirationSettingsResponse(
    channelArn: Optional[ChimeArn] = Optional.Absent,
    expirationSettings: Optional[
      zio.aws.chimesdkmessaging.model.ExpirationSettings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.PutChannelExpirationSettingsResponse = {
    import PutChannelExpirationSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.PutChannelExpirationSettingsResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(expirationSettings.map(value => value.buildAwsValue()))(
        _.expirationSettings
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.PutChannelExpirationSettingsResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.PutChannelExpirationSettingsResponse
      .wrap(buildAwsValue())
}
object PutChannelExpirationSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.PutChannelExpirationSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.PutChannelExpirationSettingsResponse =
      zio.aws.chimesdkmessaging.model.PutChannelExpirationSettingsResponse(
        channelArn.map(value => value),
        expirationSettings.map(value => value.asEditable)
      )
    def channelArn: Optional[ChimeArn]
    def expirationSettings
        : Optional[zio.aws.chimesdkmessaging.model.ExpirationSettings.ReadOnly]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getExpirationSettings: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ExpirationSettings.ReadOnly
    ] = AwsError.unwrapOptionField("expirationSettings", expirationSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.PutChannelExpirationSettingsResponse
  ) extends zio.aws.chimesdkmessaging.model.PutChannelExpirationSettingsResponse.ReadOnly {
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val expirationSettings: Optional[
      zio.aws.chimesdkmessaging.model.ExpirationSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.expirationSettings())
      .map(value =>
        zio.aws.chimesdkmessaging.model.ExpirationSettings.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.PutChannelExpirationSettingsResponse
  ): zio.aws.chimesdkmessaging.model.PutChannelExpirationSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
