package zio.aws.chimesdkmessaging.model
import zio.aws.chimesdkmessaging.model.primitives.{
  NextToken,
  MaxResults,
  ChimeArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListChannelsModeratedByAppInstanceUserRequest(
    appInstanceUserArn: Optional[ChimeArn] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    chimeBearer: ChimeArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserRequest = {
    import ListChannelsModeratedByAppInstanceUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserRequest
      .builder()
      .optionallyWith(
        appInstanceUserArn.map(value =>
          ChimeArn.unwrap(value): java.lang.String
        )
      )(_.appInstanceUserArn)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .chimeBearer(ChimeArn.unwrap(chimeBearer): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserRequest
      .wrap(buildAwsValue())
}
object ListChannelsModeratedByAppInstanceUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserRequest =
      zio.aws.chimesdkmessaging.model
        .ListChannelsModeratedByAppInstanceUserRequest(
          appInstanceUserArn.map(value => value),
          maxResults.map(value => value),
          nextToken.map(value => value),
          chimeBearer
        )
    def appInstanceUserArn: Optional[ChimeArn]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def chimeBearer: ChimeArn
    def getAppInstanceUserArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("appInstanceUserArn", appInstanceUserArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getChimeBearer: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserRequest
  ) extends zio.aws.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserRequest.ReadOnly {
    override val appInstanceUserArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.appInstanceUserArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.MaxResults(value)
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.NextToken(value))
    override val chimeBearer: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.chimeBearer())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserRequest
  ): zio.aws.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserRequest.ReadOnly =
    new Wrapper(impl)
}
