package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmessaging.model.primitives.{TagKey, ChimeArn}
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceARN: ChimeArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.UntagResourceRequest
      .builder()
      .resourceARN(ChimeArn.unwrap(resourceARN): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.UntagResourceRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.UntagResourceRequest =
      zio.aws.chimesdkmessaging.model.UntagResourceRequest(resourceARN, tagKeys)
    def resourceARN: ChimeArn
    def tagKeys: List[TagKey]
    def getResourceARN: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(resourceARN)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.UntagResourceRequest
  ) extends zio.aws.chimesdkmessaging.model.UntagResourceRequest.ReadOnly {
    override val resourceARN: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.resourceARN())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.chimesdkmessaging.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.UntagResourceRequest
  ): zio.aws.chimesdkmessaging.model.UntagResourceRequest.ReadOnly =
    new Wrapper(impl)
}
