package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.StatusDetail
import scala.jdk.CollectionConverters._
final case class ChannelMessageStatusStructure(
    value: Optional[zio.aws.chimesdkmessaging.model.ChannelMessageStatus] =
      Optional.Absent,
    detail: Optional[StatusDetail] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageStatusStructure = {
    import ChannelMessageStatusStructure.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageStatusStructure
      .builder()
      .optionallyWith(value.map(value => value.unwrap))(_.value)
      .optionallyWith(
        detail.map(value => StatusDetail.unwrap(value): java.lang.String)
      )(_.detail)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure.ReadOnly =
    zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure
      .wrap(buildAwsValue())
}
object ChannelMessageStatusStructure {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageStatusStructure
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure =
      zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure(
        value.map(value => value),
        detail.map(value => value)
      )
    def value: Optional[zio.aws.chimesdkmessaging.model.ChannelMessageStatus]
    def detail: Optional[StatusDetail]
    def getValue: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelMessageStatus
    ] = AwsError.unwrapOptionField("value", value)
    def getDetail: ZIO[Any, AwsError, StatusDetail] =
      AwsError.unwrapOptionField("detail", detail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageStatusStructure
  ) extends zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure.ReadOnly {
    override val value
        : Optional[zio.aws.chimesdkmessaging.model.ChannelMessageStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value =>
          zio.aws.chimesdkmessaging.model.ChannelMessageStatus.wrap(value)
        )
    override val detail: Optional[StatusDetail] = zio.aws.core.internal
      .optionalFromNullable(impl.detail())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.StatusDetail(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageStatusStructure
  ): zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure.ReadOnly =
    new Wrapper(impl)
}
