package zio.aws.chimesdkmessaging.model
import zio.aws.chimesdkmessaging.model.primitives.{
  NextToken,
  MaxResults,
  ChimeArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchChannelsRequest(
    chimeBearer: Optional[ChimeArn] = Optional.Absent,
    fields: Iterable[zio.aws.chimesdkmessaging.model.SearchField],
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.SearchChannelsRequest = {
    import SearchChannelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.SearchChannelsRequest
      .builder()
      .optionallyWith(
        chimeBearer.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.chimeBearer)
      .fields(fields.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.SearchChannelsRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.SearchChannelsRequest.wrap(buildAwsValue())
}
object SearchChannelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.SearchChannelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.SearchChannelsRequest =
      zio.aws.chimesdkmessaging.model.SearchChannelsRequest(
        chimeBearer.map(value => value),
        fields.map { item =>
          item.asEditable
        },
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def chimeBearer: Optional[ChimeArn]
    def fields: List[zio.aws.chimesdkmessaging.model.SearchField.ReadOnly]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getChimeBearer: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("chimeBearer", chimeBearer)
    def getFields: ZIO[Any, Nothing, List[
      zio.aws.chimesdkmessaging.model.SearchField.ReadOnly
    ]] = ZIO.succeed(fields)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.SearchChannelsRequest
  ) extends zio.aws.chimesdkmessaging.model.SearchChannelsRequest.ReadOnly {
    override val chimeBearer: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.chimeBearer())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val fields
        : List[zio.aws.chimesdkmessaging.model.SearchField.ReadOnly] = impl
      .fields()
      .asScala
      .map { item =>
        zio.aws.chimesdkmessaging.model.SearchField.wrap(item)
      }
      .toList
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.MaxResults(value)
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.SearchChannelsRequest
  ): zio.aws.chimesdkmessaging.model.SearchChannelsRequest.ReadOnly =
    new Wrapper(impl)
}
