package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutMessagingStreamingConfigurationsResponse(
    streamingConfigurations: Optional[
      Iterable[zio.aws.chimesdkmessaging.model.StreamingConfiguration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.PutMessagingStreamingConfigurationsResponse = {
    import PutMessagingStreamingConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.PutMessagingStreamingConfigurationsResponse
      .builder()
      .optionallyWith(
        streamingConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.streamingConfigurations)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.PutMessagingStreamingConfigurationsResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.PutMessagingStreamingConfigurationsResponse
      .wrap(buildAwsValue())
}
object PutMessagingStreamingConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.PutMessagingStreamingConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.PutMessagingStreamingConfigurationsResponse =
      zio.aws.chimesdkmessaging.model
        .PutMessagingStreamingConfigurationsResponse(
          streamingConfigurations.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def streamingConfigurations: Optional[
      List[zio.aws.chimesdkmessaging.model.StreamingConfiguration.ReadOnly]
    ]
    def getStreamingConfigurations: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmessaging.model.StreamingConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "streamingConfigurations",
      streamingConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.PutMessagingStreamingConfigurationsResponse
  ) extends zio.aws.chimesdkmessaging.model.PutMessagingStreamingConfigurationsResponse.ReadOnly {
    override val streamingConfigurations: Optional[
      List[zio.aws.chimesdkmessaging.model.StreamingConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.streamingConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmessaging.model.StreamingConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.PutMessagingStreamingConfigurationsResponse
  ): zio.aws.chimesdkmessaging.model.PutMessagingStreamingConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
