package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class UpdateChannelReadMarkerRequest(
    channelArn: ChimeArn,
    chimeBearer: ChimeArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelReadMarkerRequest = {
    import UpdateChannelReadMarkerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelReadMarkerRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .chimeBearer(ChimeArn.unwrap(chimeBearer): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.UpdateChannelReadMarkerRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.UpdateChannelReadMarkerRequest
      .wrap(buildAwsValue())
}
object UpdateChannelReadMarkerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelReadMarkerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.UpdateChannelReadMarkerRequest =
      zio.aws.chimesdkmessaging.model
        .UpdateChannelReadMarkerRequest(channelArn, chimeBearer)
    def channelArn: ChimeArn
    def chimeBearer: ChimeArn
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getChimeBearer: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelReadMarkerRequest
  ) extends zio.aws.chimesdkmessaging.model.UpdateChannelReadMarkerRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelArn())
    override val chimeBearer: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.chimeBearer())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelReadMarkerRequest
  ): zio.aws.chimesdkmessaging.model.UpdateChannelReadMarkerRequest.ReadOnly =
    new Wrapper(impl)
}
