package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.{
  MessageId,
  ContentType,
  ChimeArn,
  NonEmptyContent,
  SubChannelId,
  Metadata
}
import scala.jdk.CollectionConverters._
final case class UpdateChannelMessageRequest(
    channelArn: ChimeArn,
    messageId: MessageId,
    content: NonEmptyContent,
    metadata: Optional[Metadata] = Optional.Absent,
    chimeBearer: ChimeArn,
    subChannelId: Optional[SubChannelId] = Optional.Absent,
    contentType: Optional[ContentType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelMessageRequest = {
    import UpdateChannelMessageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelMessageRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .messageId(MessageId.unwrap(messageId): java.lang.String)
      .content(NonEmptyContent.unwrap(content): java.lang.String)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .chimeBearer(ChimeArn.unwrap(chimeBearer): java.lang.String)
      .optionallyWith(
        subChannelId.map(value => SubChannelId.unwrap(value): java.lang.String)
      )(_.subChannelId)
      .optionallyWith(
        contentType.map(value => ContentType.unwrap(value): java.lang.String)
      )(_.contentType)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.UpdateChannelMessageRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.UpdateChannelMessageRequest
      .wrap(buildAwsValue())
}
object UpdateChannelMessageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelMessageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.UpdateChannelMessageRequest =
      zio.aws.chimesdkmessaging.model.UpdateChannelMessageRequest(
        channelArn,
        messageId,
        content,
        metadata.map(value => value),
        chimeBearer,
        subChannelId.map(value => value),
        contentType.map(value => value)
      )
    def channelArn: ChimeArn
    def messageId: MessageId
    def content: NonEmptyContent
    def metadata: Optional[Metadata]
    def chimeBearer: ChimeArn
    def subChannelId: Optional[SubChannelId]
    def contentType: Optional[ContentType]
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getMessageId: ZIO[Any, Nothing, MessageId] = ZIO.succeed(messageId)
    def getContent: ZIO[Any, Nothing, NonEmptyContent] = ZIO.succeed(content)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getChimeBearer: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(chimeBearer)
    def getSubChannelId: ZIO[Any, AwsError, SubChannelId] =
      AwsError.unwrapOptionField("subChannelId", subChannelId)
    def getContentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelMessageRequest
  ) extends zio.aws.chimesdkmessaging.model.UpdateChannelMessageRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelArn())
    override val messageId: MessageId =
      zio.aws.chimesdkmessaging.model.primitives.MessageId(impl.messageId())
    override val content: NonEmptyContent =
      zio.aws.chimesdkmessaging.model.primitives.NonEmptyContent(impl.content())
    override val metadata: Optional[Metadata] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Metadata(value))
    override val chimeBearer: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.chimeBearer())
    override val subChannelId: Optional[SubChannelId] = zio.aws.core.internal
      .optionalFromNullable(impl.subChannelId())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.SubChannelId(value)
      )
    override val contentType: Optional[ContentType] = zio.aws.core.internal
      .optionalFromNullable(impl.contentType())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.ContentType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelMessageRequest
  ): zio.aws.chimesdkmessaging.model.UpdateChannelMessageRequest.ReadOnly =
    new Wrapper(impl)
}
