package zio.aws.chimesdkmessaging.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmessaging.model.primitives.ExpirationDays
import scala.jdk.CollectionConverters._
final case class ExpirationSettings(
    expirationDays: ExpirationDays,
    expirationCriterion: zio.aws.chimesdkmessaging.model.ExpirationCriterion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ExpirationSettings = {
    import ExpirationSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ExpirationSettings
      .builder()
      .expirationDays(ExpirationDays.unwrap(expirationDays): Integer)
      .expirationCriterion(expirationCriterion.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.chimesdkmessaging.model.ExpirationSettings.ReadOnly =
    zio.aws.chimesdkmessaging.model.ExpirationSettings.wrap(buildAwsValue())
}
object ExpirationSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ExpirationSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.ExpirationSettings =
      zio.aws.chimesdkmessaging.model
        .ExpirationSettings(expirationDays, expirationCriterion)
    def expirationDays: ExpirationDays
    def expirationCriterion: zio.aws.chimesdkmessaging.model.ExpirationCriterion
    def getExpirationDays: ZIO[Any, Nothing, ExpirationDays] =
      ZIO.succeed(expirationDays)
    def getExpirationCriterion: ZIO[
      Any,
      Nothing,
      zio.aws.chimesdkmessaging.model.ExpirationCriterion
    ] = ZIO.succeed(expirationCriterion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ExpirationSettings
  ) extends zio.aws.chimesdkmessaging.model.ExpirationSettings.ReadOnly {
    override val expirationDays: ExpirationDays =
      zio.aws.chimesdkmessaging.model.primitives
        .ExpirationDays(impl.expirationDays())
    override val expirationCriterion
        : zio.aws.chimesdkmessaging.model.ExpirationCriterion =
      zio.aws.chimesdkmessaging.model.ExpirationCriterion
        .wrap(impl.expirationCriterion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ExpirationSettings
  ): zio.aws.chimesdkmessaging.model.ExpirationSettings.ReadOnly = new Wrapper(
    impl
  )
}
