package zio.aws.chimesdkmessaging.model
import scala.jdk.CollectionConverters._
sealed trait ExpirationCriterion {
  def unwrap: software.amazon.awssdk.services.chimesdkmessaging.model.ExpirationCriterion
}
object ExpirationCriterion {
  def wrap(
      value: software.amazon.awssdk.services.chimesdkmessaging.model.ExpirationCriterion
  ): zio.aws.chimesdkmessaging.model.ExpirationCriterion = value match {
    case software.amazon.awssdk.services.chimesdkmessaging.model.ExpirationCriterion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chimesdkmessaging.model.ExpirationCriterion.CREATED_TIMESTAMP =>
      val r = CREATED_TIMESTAMP
      r
    case software.amazon.awssdk.services.chimesdkmessaging.model.ExpirationCriterion.LAST_MESSAGE_TIMESTAMP =>
      val r = LAST_MESSAGE_TIMESTAMP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chimesdkmessaging.model.ExpirationCriterion {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.ExpirationCriterion =
      software.amazon.awssdk.services.chimesdkmessaging.model.ExpirationCriterion.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATED_TIMESTAMP
      extends zio.aws.chimesdkmessaging.model.ExpirationCriterion {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.ExpirationCriterion =
      software.amazon.awssdk.services.chimesdkmessaging.model.ExpirationCriterion.CREATED_TIMESTAMP
  }
  case object LAST_MESSAGE_TIMESTAMP
      extends zio.aws.chimesdkmessaging.model.ExpirationCriterion {
    override def unwrap
        : software.amazon.awssdk.services.chimesdkmessaging.model.ExpirationCriterion =
      software.amazon.awssdk.services.chimesdkmessaging.model.ExpirationCriterion.LAST_MESSAGE_TIMESTAMP
  }
}
