package zio.aws.chimesdkmessaging.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmessaging.model.primitives.{
  MinimumMembershipPercentage,
  TargetMembershipsPerSubChannel,
  MaximumSubChannels
}
import scala.jdk.CollectionConverters._
final case class ElasticChannelConfiguration(
    maximumSubChannels: MaximumSubChannels,
    targetMembershipsPerSubChannel: TargetMembershipsPerSubChannel,
    minimumMembershipPercentage: MinimumMembershipPercentage
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ElasticChannelConfiguration = {
    import ElasticChannelConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ElasticChannelConfiguration
      .builder()
      .maximumSubChannels(
        MaximumSubChannels.unwrap(maximumSubChannels): Integer
      )
      .targetMembershipsPerSubChannel(
        TargetMembershipsPerSubChannel.unwrap(
          targetMembershipsPerSubChannel
        ): Integer
      )
      .minimumMembershipPercentage(
        MinimumMembershipPercentage.unwrap(minimumMembershipPercentage): Integer
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ElasticChannelConfiguration.ReadOnly =
    zio.aws.chimesdkmessaging.model.ElasticChannelConfiguration
      .wrap(buildAwsValue())
}
object ElasticChannelConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ElasticChannelConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.ElasticChannelConfiguration =
      zio.aws.chimesdkmessaging.model.ElasticChannelConfiguration(
        maximumSubChannels,
        targetMembershipsPerSubChannel,
        minimumMembershipPercentage
      )
    def maximumSubChannels: MaximumSubChannels
    def targetMembershipsPerSubChannel: TargetMembershipsPerSubChannel
    def minimumMembershipPercentage: MinimumMembershipPercentage
    def getMaximumSubChannels: ZIO[Any, Nothing, MaximumSubChannels] =
      ZIO.succeed(maximumSubChannels)
    def getTargetMembershipsPerSubChannel
        : ZIO[Any, Nothing, TargetMembershipsPerSubChannel] =
      ZIO.succeed(targetMembershipsPerSubChannel)
    def getMinimumMembershipPercentage
        : ZIO[Any, Nothing, MinimumMembershipPercentage] =
      ZIO.succeed(minimumMembershipPercentage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ElasticChannelConfiguration
  ) extends zio.aws.chimesdkmessaging.model.ElasticChannelConfiguration.ReadOnly {
    override val maximumSubChannels: MaximumSubChannels =
      zio.aws.chimesdkmessaging.model.primitives
        .MaximumSubChannels(impl.maximumSubChannels())
    override val targetMembershipsPerSubChannel
        : TargetMembershipsPerSubChannel =
      zio.aws.chimesdkmessaging.model.primitives
        .TargetMembershipsPerSubChannel(impl.targetMembershipsPerSubChannel())
    override val minimumMembershipPercentage: MinimumMembershipPercentage =
      zio.aws.chimesdkmessaging.model.primitives
        .MinimumMembershipPercentage(impl.minimumMembershipPercentage())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ElasticChannelConfiguration
  ): zio.aws.chimesdkmessaging.model.ElasticChannelConfiguration.ReadOnly =
    new Wrapper(impl)
}
