package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.{SubChannelId, ChimeArn}
import scala.jdk.CollectionConverters._
final case class BatchCreateChannelMembershipRequest(
    channelArn: ChimeArn,
    `type`: Optional[zio.aws.chimesdkmessaging.model.ChannelMembershipType] =
      Optional.Absent,
    memberArns: Iterable[ChimeArn],
    chimeBearer: ChimeArn,
    subChannelId: Optional[SubChannelId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.BatchCreateChannelMembershipRequest = {
    import BatchCreateChannelMembershipRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.BatchCreateChannelMembershipRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .memberArns(memberArns.map { item =>
        ChimeArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .chimeBearer(ChimeArn.unwrap(chimeBearer): java.lang.String)
      .optionallyWith(
        subChannelId.map(value => SubChannelId.unwrap(value): java.lang.String)
      )(_.subChannelId)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipRequest
      .wrap(buildAwsValue())
}
object BatchCreateChannelMembershipRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.BatchCreateChannelMembershipRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipRequest =
      zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipRequest(
        channelArn,
        `type`.map(value => value),
        memberArns,
        chimeBearer,
        subChannelId.map(value => value)
      )
    def channelArn: ChimeArn
    def `type`: Optional[zio.aws.chimesdkmessaging.model.ChannelMembershipType]
    def memberArns: List[ChimeArn]
    def chimeBearer: ChimeArn
    def subChannelId: Optional[SubChannelId]
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelMembershipType
    ] = AwsError.unwrapOptionField("type", `type`)
    def getMemberArns: ZIO[Any, Nothing, List[ChimeArn]] =
      ZIO.succeed(memberArns)
    def getChimeBearer: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(chimeBearer)
    def getSubChannelId: ZIO[Any, AwsError, SubChannelId] =
      AwsError.unwrapOptionField("subChannelId", subChannelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.BatchCreateChannelMembershipRequest
  ) extends zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelArn())
    override val `type`
        : Optional[zio.aws.chimesdkmessaging.model.ChannelMembershipType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.chimesdkmessaging.model.ChannelMembershipType.wrap(value)
        )
    override val memberArns: List[ChimeArn] = impl
      .memberArns()
      .asScala
      .map { item =>
        zio.aws.chimesdkmessaging.model.primitives.ChimeArn(item)
      }
      .toList
    override val chimeBearer: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.chimeBearer())
    override val subChannelId: Optional[SubChannelId] = zio.aws.core.internal
      .optionalFromNullable(impl.subChannelId())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.SubChannelId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.BatchCreateChannelMembershipRequest
  ): zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipRequest.ReadOnly =
    new Wrapper(impl)
}
