package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeChannelFlowResponse(
    channelFlow: Optional[zio.aws.chimesdkmessaging.model.ChannelFlow] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelFlowResponse = {
    import DescribeChannelFlowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelFlowResponse
      .builder()
      .optionallyWith(channelFlow.map(value => value.buildAwsValue()))(
        _.channelFlow
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.DescribeChannelFlowResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.DescribeChannelFlowResponse
      .wrap(buildAwsValue())
}
object DescribeChannelFlowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelFlowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.DescribeChannelFlowResponse =
      zio.aws.chimesdkmessaging.model
        .DescribeChannelFlowResponse(channelFlow.map(value => value.asEditable))
    def channelFlow
        : Optional[zio.aws.chimesdkmessaging.model.ChannelFlow.ReadOnly]
    def getChannelFlow: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelFlow.ReadOnly
    ] = AwsError.unwrapOptionField("channelFlow", channelFlow)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelFlowResponse
  ) extends zio.aws.chimesdkmessaging.model.DescribeChannelFlowResponse.ReadOnly {
    override val channelFlow
        : Optional[zio.aws.chimesdkmessaging.model.ChannelFlow.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channelFlow())
        .map(value => zio.aws.chimesdkmessaging.model.ChannelFlow.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.DescribeChannelFlowResponse
  ): zio.aws.chimesdkmessaging.model.DescribeChannelFlowResponse.ReadOnly =
    new Wrapper(impl)
}
