package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class StreamingConfiguration(
    dataType: zio.aws.chimesdkmessaging.model.MessagingDataType,
    resourceArn: ChimeArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.StreamingConfiguration = {
    import StreamingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.StreamingConfiguration
      .builder()
      .dataType(dataType.unwrap)
      .resourceArn(ChimeArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.StreamingConfiguration.ReadOnly =
    zio.aws.chimesdkmessaging.model.StreamingConfiguration.wrap(buildAwsValue())
}
object StreamingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.StreamingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.StreamingConfiguration =
      zio.aws.chimesdkmessaging.model
        .StreamingConfiguration(dataType, resourceArn)
    def dataType: zio.aws.chimesdkmessaging.model.MessagingDataType
    def resourceArn: ChimeArn
    def getDataType
        : ZIO[Any, Nothing, zio.aws.chimesdkmessaging.model.MessagingDataType] =
      ZIO.succeed(dataType)
    def getResourceArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.StreamingConfiguration
  ) extends zio.aws.chimesdkmessaging.model.StreamingConfiguration.ReadOnly {
    override val dataType: zio.aws.chimesdkmessaging.model.MessagingDataType =
      zio.aws.chimesdkmessaging.model.MessagingDataType.wrap(impl.dataType())
    override val resourceArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.StreamingConfiguration
  ): zio.aws.chimesdkmessaging.model.StreamingConfiguration.ReadOnly =
    new Wrapper(impl)
}
