package zio.aws.chimesdkmessaging.model
import zio.aws.chimesdkmessaging.model.primitives.{SubChannelId, Timestamp}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class AppInstanceUserMembershipSummary(
    `type`: Optional[zio.aws.chimesdkmessaging.model.ChannelMembershipType] =
      Optional.Absent,
    readMarkerTimestamp: Optional[Timestamp] = Optional.Absent,
    subChannelId: Optional[SubChannelId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.AppInstanceUserMembershipSummary = {
    import AppInstanceUserMembershipSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.AppInstanceUserMembershipSummary
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        readMarkerTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.readMarkerTimestamp)
      .optionallyWith(
        subChannelId.map(value => SubChannelId.unwrap(value): java.lang.String)
      )(_.subChannelId)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.AppInstanceUserMembershipSummary.ReadOnly =
    zio.aws.chimesdkmessaging.model.AppInstanceUserMembershipSummary
      .wrap(buildAwsValue())
}
object AppInstanceUserMembershipSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.AppInstanceUserMembershipSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.AppInstanceUserMembershipSummary =
      zio.aws.chimesdkmessaging.model.AppInstanceUserMembershipSummary(
        `type`.map(value => value),
        readMarkerTimestamp.map(value => value),
        subChannelId.map(value => value)
      )
    def `type`: Optional[zio.aws.chimesdkmessaging.model.ChannelMembershipType]
    def readMarkerTimestamp: Optional[Timestamp]
    def subChannelId: Optional[SubChannelId]
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelMembershipType
    ] = AwsError.unwrapOptionField("type", `type`)
    def getReadMarkerTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("readMarkerTimestamp", readMarkerTimestamp)
    def getSubChannelId: ZIO[Any, AwsError, SubChannelId] =
      AwsError.unwrapOptionField("subChannelId", subChannelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.AppInstanceUserMembershipSummary
  ) extends zio.aws.chimesdkmessaging.model.AppInstanceUserMembershipSummary.ReadOnly {
    override val `type`
        : Optional[zio.aws.chimesdkmessaging.model.ChannelMembershipType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.chimesdkmessaging.model.ChannelMembershipType.wrap(value)
        )
    override val readMarkerTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readMarkerTimestamp())
        .map(value =>
          zio.aws.chimesdkmessaging.model.primitives.Timestamp(value)
        )
    override val subChannelId: Optional[SubChannelId] = zio.aws.core.internal
      .optionalFromNullable(impl.subChannelId())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.SubChannelId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.AppInstanceUserMembershipSummary
  ): zio.aws.chimesdkmessaging.model.AppInstanceUserMembershipSummary.ReadOnly =
    new Wrapper(impl)
}
