package zio.aws.chimesdkmessaging
import zio.aws.chimesdkmessaging.model.ListTagsForResourceResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.chimesdkmessaging.ChimeSdkMessagingAsyncClient
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.aws.chimesdkmessaging.model.{
  ListChannelBansRequest,
  ListChannelFlowsRequest,
  ListSubChannelsRequest,
  DeleteChannelModeratorRequest,
  BatchCreateChannelMembershipRequest,
  UpdateChannelReadMarkerRequest,
  ListChannelMessagesRequest,
  GetChannelMessageRequest,
  RedactChannelMessageRequest,
  DeleteChannelRequest,
  ChannelFlowCallbackRequest,
  DeleteChannelMembershipRequest,
  DisassociateChannelFlowRequest,
  DescribeChannelModeratedByAppInstanceUserRequest,
  CreateChannelRequest,
  DescribeChannelMembershipRequest,
  DeleteChannelFlowRequest,
  ListTagsForResourceRequest,
  UpdateChannelMessageRequest,
  PutChannelExpirationSettingsRequest,
  PutChannelMembershipPreferencesRequest,
  CreateChannelMembershipRequest,
  DescribeChannelFlowRequest,
  SearchChannelsRequest,
  ListChannelMembershipsForAppInstanceUserRequest,
  ListChannelsAssociatedWithChannelFlowRequest,
  DeleteChannelBanRequest,
  UpdateChannelFlowRequest,
  DescribeChannelMembershipForAppInstanceUserRequest,
  CreateChannelFlowRequest,
  UpdateChannelRequest,
  DescribeChannelBanRequest,
  AssociateChannelFlowRequest,
  GetChannelMembershipPreferencesRequest,
  ListChannelsRequest,
  ListChannelModeratorsRequest,
  SendChannelMessageRequest,
  UntagResourceRequest,
  CreateChannelBanRequest,
  DeleteMessagingStreamingConfigurationsRequest,
  GetMessagingSessionEndpointRequest,
  DeleteChannelMessageRequest,
  PutMessagingStreamingConfigurationsRequest,
  GetChannelMessageStatusRequest,
  DescribeChannelRequest,
  CreateChannelModeratorRequest,
  TagResourceRequest,
  DescribeChannelModeratorRequest,
  ListChannelMembershipsRequest,
  ListChannelsModeratedByAppInstanceUserRequest,
  GetMessagingStreamingConfigurationsRequest
}
import zio.stream.ZStream
object ChimeSdkMessagingMock extends Mock[ChimeSdkMessaging] {
  object DescribeChannelMembership
      extends Effect[
        DescribeChannelMembershipRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.DescribeChannelMembershipResponse.ReadOnly
      ]
  object ListSubChannels
      extends Effect[ListSubChannelsRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.chimesdkmessaging.model.ListSubChannelsResponse.ReadOnly,
        zio.aws.chimesdkmessaging.model.SubChannelSummary.ReadOnly
      ]]
  object ListSubChannelsPaginated
      extends Effect[
        ListSubChannelsRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.ListSubChannelsResponse.ReadOnly
      ]
  object ListChannels
      extends Stream[
        ListChannelsRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.ChannelSummary.ReadOnly
      ]
  object ListChannelsPaginated
      extends Effect[
        ListChannelsRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.ListChannelsResponse.ReadOnly
      ]
  object ChannelFlowCallback
      extends Effect[
        ChannelFlowCallbackRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.ChannelFlowCallbackResponse.ReadOnly
      ]
  object ListChannelsAssociatedWithChannelFlow
      extends Stream[
        ListChannelsAssociatedWithChannelFlowRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary.ReadOnly
      ]
  object ListChannelsAssociatedWithChannelFlowPaginated
      extends Effect[
        ListChannelsAssociatedWithChannelFlowRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowResponse.ReadOnly
      ]
  object DeleteChannelModerator
      extends Effect[DeleteChannelModeratorRequest, AwsError, Unit]
  object PutChannelExpirationSettings
      extends Effect[
        PutChannelExpirationSettingsRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.PutChannelExpirationSettingsResponse.ReadOnly
      ]
  object DescribeChannelModeratedByAppInstanceUser
      extends Effect[
        DescribeChannelModeratedByAppInstanceUserRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.DescribeChannelModeratedByAppInstanceUserResponse.ReadOnly
      ]
  object ListChannelMembershipsForAppInstanceUser
      extends Stream[
        ListChannelMembershipsForAppInstanceUserRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.ChannelMembershipForAppInstanceUserSummary.ReadOnly
      ]
  object ListChannelMembershipsForAppInstanceUserPaginated
      extends Effect[
        ListChannelMembershipsForAppInstanceUserRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserResponse.ReadOnly
      ]
  object SendChannelMessage
      extends Effect[
        SendChannelMessageRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.SendChannelMessageResponse.ReadOnly
      ]
  object DeleteChannelMembership
      extends Effect[DeleteChannelMembershipRequest, AwsError, Unit]
  object PutChannelMembershipPreferences
      extends Effect[
        PutChannelMembershipPreferencesRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.PutChannelMembershipPreferencesResponse.ReadOnly
      ]
  object ListChannelFlows
      extends Stream[
        ListChannelFlowsRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.ChannelFlowSummary.ReadOnly
      ]
  object ListChannelFlowsPaginated
      extends Effect[
        ListChannelFlowsRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.ListChannelFlowsResponse.ReadOnly
      ]
  object DeleteChannel extends Effect[DeleteChannelRequest, AwsError, Unit]
  object DeleteMessagingStreamingConfigurations
      extends Effect[
        DeleteMessagingStreamingConfigurationsRequest,
        AwsError,
        Unit
      ]
  object ListChannelBans
      extends Effect[ListChannelBansRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.chimesdkmessaging.model.ListChannelBansResponse.ReadOnly,
        zio.aws.chimesdkmessaging.model.ChannelBanSummary.ReadOnly
      ]]
  object ListChannelBansPaginated
      extends Effect[
        ListChannelBansRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.ListChannelBansResponse.ReadOnly
      ]
  object ListChannelMessages
      extends Effect[
        ListChannelMessagesRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.chimesdkmessaging.model.ListChannelMessagesResponse.ReadOnly,
          zio.aws.chimesdkmessaging.model.ChannelMessageSummary.ReadOnly
        ]
      ]
  object ListChannelMessagesPaginated
      extends Effect[
        ListChannelMessagesRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.ListChannelMessagesResponse.ReadOnly
      ]
  object AssociateChannelFlow
      extends Effect[AssociateChannelFlowRequest, AwsError, Unit]
  object DeleteChannelFlow
      extends Effect[DeleteChannelFlowRequest, AwsError, Unit]
  object CreateChannelMembership
      extends Effect[
        CreateChannelMembershipRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.CreateChannelMembershipResponse.ReadOnly
      ]
  object CreateChannel
      extends Effect[
        CreateChannelRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.CreateChannelResponse.ReadOnly
      ]
  object DescribeChannelBan
      extends Effect[
        DescribeChannelBanRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.DescribeChannelBanResponse.ReadOnly
      ]
  object ListChannelMemberships
      extends Effect[ListChannelMembershipsRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.chimesdkmessaging.model.ListChannelMembershipsResponse.ReadOnly,
        zio.aws.chimesdkmessaging.model.ChannelMembershipSummary.ReadOnly
      ]]
  object ListChannelMembershipsPaginated
      extends Effect[
        ListChannelMembershipsRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.ListChannelMembershipsResponse.ReadOnly
      ]
  object BatchCreateChannelMembership
      extends Effect[
        BatchCreateChannelMembershipRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipResponse.ReadOnly
      ]
  object GetMessagingStreamingConfigurations
      extends Effect[
        GetMessagingStreamingConfigurationsRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.GetMessagingStreamingConfigurationsResponse.ReadOnly
      ]
  object UpdateChannelFlow
      extends Effect[
        UpdateChannelFlowRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.UpdateChannelFlowResponse.ReadOnly
      ]
  object UpdateChannelReadMarker
      extends Effect[
        UpdateChannelReadMarkerRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.UpdateChannelReadMarkerResponse.ReadOnly
      ]
  object CreateChannelModerator
      extends Effect[
        CreateChannelModeratorRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.CreateChannelModeratorResponse.ReadOnly
      ]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object GetChannelMessage
      extends Effect[
        GetChannelMessageRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.GetChannelMessageResponse.ReadOnly
      ]
  object CreateChannelBan
      extends Effect[
        CreateChannelBanRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.CreateChannelBanResponse.ReadOnly
      ]
  object DeleteChannelMessage
      extends Effect[DeleteChannelMessageRequest, AwsError, Unit]
  object RedactChannelMessage
      extends Effect[
        RedactChannelMessageRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.RedactChannelMessageResponse.ReadOnly
      ]
  object SearchChannels
      extends Stream[
        SearchChannelsRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.ChannelSummary.ReadOnly
      ]
  object SearchChannelsPaginated
      extends Effect[
        SearchChannelsRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.SearchChannelsResponse.ReadOnly
      ]
  object DeleteChannelBan
      extends Effect[DeleteChannelBanRequest, AwsError, Unit]
  object DescribeChannelModerator
      extends Effect[
        DescribeChannelModeratorRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.DescribeChannelModeratorResponse.ReadOnly
      ]
  object DescribeChannelMembershipForAppInstanceUser
      extends Effect[
        DescribeChannelMembershipForAppInstanceUserRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[ListTagsForResourceRequest, AwsError, ReadOnly]
  object DisassociateChannelFlow
      extends Effect[DisassociateChannelFlowRequest, AwsError, Unit]
  object GetChannelMembershipPreferences
      extends Effect[
        GetChannelMembershipPreferencesRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.GetChannelMembershipPreferencesResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object DescribeChannel
      extends Effect[
        DescribeChannelRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.DescribeChannelResponse.ReadOnly
      ]
  object CreateChannelFlow
      extends Effect[
        CreateChannelFlowRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.CreateChannelFlowResponse.ReadOnly
      ]
  object ListChannelModerators
      extends Effect[
        ListChannelModeratorsRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.chimesdkmessaging.model.ListChannelModeratorsResponse.ReadOnly,
          zio.aws.chimesdkmessaging.model.ChannelModeratorSummary.ReadOnly
        ]
      ]
  object ListChannelModeratorsPaginated
      extends Effect[
        ListChannelModeratorsRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.ListChannelModeratorsResponse.ReadOnly
      ]
  object GetChannelMessageStatus
      extends Effect[
        GetChannelMessageStatusRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.GetChannelMessageStatusResponse.ReadOnly
      ]
  object ListChannelsModeratedByAppInstanceUser
      extends Stream[
        ListChannelsModeratedByAppInstanceUserRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.ChannelModeratedByAppInstanceUserSummary.ReadOnly
      ]
  object ListChannelsModeratedByAppInstanceUserPaginated
      extends Effect[
        ListChannelsModeratedByAppInstanceUserRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserResponse.ReadOnly
      ]
  object UpdateChannelMessage
      extends Effect[
        UpdateChannelMessageRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.UpdateChannelMessageResponse.ReadOnly
      ]
  object GetMessagingSessionEndpoint
      extends Effect[
        GetMessagingSessionEndpointRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.GetMessagingSessionEndpointResponse.ReadOnly
      ]
  object PutMessagingStreamingConfigurations
      extends Effect[
        PutMessagingStreamingConfigurationsRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.PutMessagingStreamingConfigurationsResponse.ReadOnly
      ]
  object UpdateChannel
      extends Effect[
        UpdateChannelRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.UpdateChannelResponse.ReadOnly
      ]
  object DescribeChannelFlow
      extends Effect[
        DescribeChannelFlowRequest,
        AwsError,
        zio.aws.chimesdkmessaging.model.DescribeChannelFlowResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ChimeSdkMessaging] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, ChimeSdkMessaging] { rts =>
        ZIO.succeed {
          new ChimeSdkMessaging {
            val api: ChimeSdkMessagingAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): ChimeSdkMessaging = this
            def describeChannelMembership(
                request: DescribeChannelMembershipRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.DescribeChannelMembershipResponse.ReadOnly
            ] = proxy(DescribeChannelMembership, request)
            def listSubChannels(
                request: ListSubChannelsRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.chimesdkmessaging.model.ListSubChannelsResponse.ReadOnly,
              zio.aws.chimesdkmessaging.model.SubChannelSummary.ReadOnly
            ]] = proxy(ListSubChannels, request)
            def listSubChannelsPaginated(request: ListSubChannelsRequest): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.ListSubChannelsResponse.ReadOnly
            ] = proxy(ListSubChannelsPaginated, request)
            def listChannels(request: ListChannelsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.chimesdkmessaging.model.ChannelSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListChannels, request)
                }
                .getOrThrowFiberFailure()
            }
            def listChannelsPaginated(request: ListChannelsRequest): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.ListChannelsResponse.ReadOnly
            ] = proxy(ListChannelsPaginated, request)
            def channelFlowCallback(request: ChannelFlowCallbackRequest): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.ChannelFlowCallbackResponse.ReadOnly
            ] = proxy(ChannelFlowCallback, request)
            def listChannelsAssociatedWithChannelFlow(
                request: ListChannelsAssociatedWithChannelFlowRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListChannelsAssociatedWithChannelFlow, request)
                }
                .getOrThrowFiberFailure()
            }
            def listChannelsAssociatedWithChannelFlowPaginated(
                request: ListChannelsAssociatedWithChannelFlowRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.ListChannelsAssociatedWithChannelFlowResponse.ReadOnly
            ] = proxy(ListChannelsAssociatedWithChannelFlowPaginated, request)
            def deleteChannelModerator(
                request: DeleteChannelModeratorRequest
            ): IO[AwsError, Unit] = proxy(DeleteChannelModerator, request)
            def putChannelExpirationSettings(
                request: PutChannelExpirationSettingsRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.PutChannelExpirationSettingsResponse.ReadOnly
            ] = proxy(PutChannelExpirationSettings, request)
            def describeChannelModeratedByAppInstanceUser(
                request: DescribeChannelModeratedByAppInstanceUserRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.DescribeChannelModeratedByAppInstanceUserResponse.ReadOnly
            ] = proxy(DescribeChannelModeratedByAppInstanceUser, request)
            def listChannelMembershipsForAppInstanceUser(
                request: ListChannelMembershipsForAppInstanceUserRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.chimesdkmessaging.model.ChannelMembershipForAppInstanceUserSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListChannelMembershipsForAppInstanceUser, request)
                }
                .getOrThrowFiberFailure()
            }
            def listChannelMembershipsForAppInstanceUserPaginated(
                request: ListChannelMembershipsForAppInstanceUserRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.ListChannelMembershipsForAppInstanceUserResponse.ReadOnly
            ] =
              proxy(ListChannelMembershipsForAppInstanceUserPaginated, request)
            def sendChannelMessage(request: SendChannelMessageRequest): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.SendChannelMessageResponse.ReadOnly
            ] = proxy(SendChannelMessage, request)
            def deleteChannelMembership(
                request: DeleteChannelMembershipRequest
            ): IO[AwsError, Unit] = proxy(DeleteChannelMembership, request)
            def putChannelMembershipPreferences(
                request: PutChannelMembershipPreferencesRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.PutChannelMembershipPreferencesResponse.ReadOnly
            ] = proxy(PutChannelMembershipPreferences, request)
            def listChannelFlows(request: ListChannelFlowsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.chimesdkmessaging.model.ChannelFlowSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListChannelFlows, request)
                }
                .getOrThrowFiberFailure()
            }
            def listChannelFlowsPaginated(request: ListChannelFlowsRequest): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.ListChannelFlowsResponse.ReadOnly
            ] = proxy(ListChannelFlowsPaginated, request)
            def deleteChannel(
                request: DeleteChannelRequest
            ): IO[AwsError, Unit] = proxy(DeleteChannel, request)
            def deleteMessagingStreamingConfigurations(
                request: DeleteMessagingStreamingConfigurationsRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteMessagingStreamingConfigurations, request)
            def listChannelBans(
                request: ListChannelBansRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.chimesdkmessaging.model.ListChannelBansResponse.ReadOnly,
              zio.aws.chimesdkmessaging.model.ChannelBanSummary.ReadOnly
            ]] = proxy(ListChannelBans, request)
            def listChannelBansPaginated(request: ListChannelBansRequest): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.ListChannelBansResponse.ReadOnly
            ] = proxy(ListChannelBansPaginated, request)
            def listChannelMessages(
                request: ListChannelMessagesRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.chimesdkmessaging.model.ListChannelMessagesResponse.ReadOnly,
              zio.aws.chimesdkmessaging.model.ChannelMessageSummary.ReadOnly
            ]] = proxy(ListChannelMessages, request)
            def listChannelMessagesPaginated(
                request: ListChannelMessagesRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.ListChannelMessagesResponse.ReadOnly
            ] = proxy(ListChannelMessagesPaginated, request)
            def associateChannelFlow(
                request: AssociateChannelFlowRequest
            ): IO[AwsError, Unit] = proxy(AssociateChannelFlow, request)
            def deleteChannelFlow(
                request: DeleteChannelFlowRequest
            ): IO[AwsError, Unit] = proxy(DeleteChannelFlow, request)
            def createChannelMembership(
                request: CreateChannelMembershipRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.CreateChannelMembershipResponse.ReadOnly
            ] = proxy(CreateChannelMembership, request)
            def createChannel(request: CreateChannelRequest): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.CreateChannelResponse.ReadOnly
            ] = proxy(CreateChannel, request)
            def describeChannelBan(request: DescribeChannelBanRequest): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.DescribeChannelBanResponse.ReadOnly
            ] = proxy(DescribeChannelBan, request)
            def listChannelMemberships(
                request: ListChannelMembershipsRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.chimesdkmessaging.model.ListChannelMembershipsResponse.ReadOnly,
              zio.aws.chimesdkmessaging.model.ChannelMembershipSummary.ReadOnly
            ]] = proxy(ListChannelMemberships, request)
            def listChannelMembershipsPaginated(
                request: ListChannelMembershipsRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.ListChannelMembershipsResponse.ReadOnly
            ] = proxy(ListChannelMembershipsPaginated, request)
            def batchCreateChannelMembership(
                request: BatchCreateChannelMembershipRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipResponse.ReadOnly
            ] = proxy(BatchCreateChannelMembership, request)
            def getMessagingStreamingConfigurations(
                request: GetMessagingStreamingConfigurationsRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.GetMessagingStreamingConfigurationsResponse.ReadOnly
            ] = proxy(GetMessagingStreamingConfigurations, request)
            def updateChannelFlow(request: UpdateChannelFlowRequest): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.UpdateChannelFlowResponse.ReadOnly
            ] = proxy(UpdateChannelFlow, request)
            def updateChannelReadMarker(
                request: UpdateChannelReadMarkerRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.UpdateChannelReadMarkerResponse.ReadOnly
            ] = proxy(UpdateChannelReadMarker, request)
            def createChannelModerator(
                request: CreateChannelModeratorRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.CreateChannelModeratorResponse.ReadOnly
            ] = proxy(CreateChannelModerator, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, Unit] = proxy(UntagResource, request)
            def getChannelMessage(request: GetChannelMessageRequest): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.GetChannelMessageResponse.ReadOnly
            ] = proxy(GetChannelMessage, request)
            def createChannelBan(request: CreateChannelBanRequest): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.CreateChannelBanResponse.ReadOnly
            ] = proxy(CreateChannelBan, request)
            def deleteChannelMessage(
                request: DeleteChannelMessageRequest
            ): IO[AwsError, Unit] = proxy(DeleteChannelMessage, request)
            def redactChannelMessage(request: RedactChannelMessageRequest): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.RedactChannelMessageResponse.ReadOnly
            ] = proxy(RedactChannelMessage, request)
            def searchChannels(request: SearchChannelsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.chimesdkmessaging.model.ChannelSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(SearchChannels, request)
                }
                .getOrThrowFiberFailure()
            }
            def searchChannelsPaginated(request: SearchChannelsRequest): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.SearchChannelsResponse.ReadOnly
            ] = proxy(SearchChannelsPaginated, request)
            def deleteChannelBan(
                request: DeleteChannelBanRequest
            ): IO[AwsError, Unit] = proxy(DeleteChannelBan, request)
            def describeChannelModerator(
                request: DescribeChannelModeratorRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.DescribeChannelModeratorResponse.ReadOnly
            ] = proxy(DescribeChannelModerator, request)
            def describeChannelMembershipForAppInstanceUser(
                request: DescribeChannelMembershipForAppInstanceUserRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.DescribeChannelMembershipForAppInstanceUserResponse.ReadOnly
            ] = proxy(DescribeChannelMembershipForAppInstanceUser, request)
            def listTagsForResource(
                request: ListTagsForResourceRequest
            ): IO[AwsError, ReadOnly] = proxy(ListTagsForResource, request)
            def disassociateChannelFlow(
                request: DisassociateChannelFlowRequest
            ): IO[AwsError, Unit] = proxy(DisassociateChannelFlow, request)
            def getChannelMembershipPreferences(
                request: GetChannelMembershipPreferencesRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.GetChannelMembershipPreferencesResponse.ReadOnly
            ] = proxy(GetChannelMembershipPreferences, request)
            def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
              proxy(TagResource, request)
            def describeChannel(request: DescribeChannelRequest): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.DescribeChannelResponse.ReadOnly
            ] = proxy(DescribeChannel, request)
            def createChannelFlow(request: CreateChannelFlowRequest): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.CreateChannelFlowResponse.ReadOnly
            ] = proxy(CreateChannelFlow, request)
            def listChannelModerators(
                request: ListChannelModeratorsRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.chimesdkmessaging.model.ListChannelModeratorsResponse.ReadOnly,
              zio.aws.chimesdkmessaging.model.ChannelModeratorSummary.ReadOnly
            ]] = proxy(ListChannelModerators, request)
            def listChannelModeratorsPaginated(
                request: ListChannelModeratorsRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.ListChannelModeratorsResponse.ReadOnly
            ] = proxy(ListChannelModeratorsPaginated, request)
            def getChannelMessageStatus(
                request: GetChannelMessageStatusRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.GetChannelMessageStatusResponse.ReadOnly
            ] = proxy(GetChannelMessageStatus, request)
            def listChannelsModeratedByAppInstanceUser(
                request: ListChannelsModeratedByAppInstanceUserRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.chimesdkmessaging.model.ChannelModeratedByAppInstanceUserSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListChannelsModeratedByAppInstanceUser, request)
                }
                .getOrThrowFiberFailure()
            }
            def listChannelsModeratedByAppInstanceUserPaginated(
                request: ListChannelsModeratedByAppInstanceUserRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.ListChannelsModeratedByAppInstanceUserResponse.ReadOnly
            ] = proxy(ListChannelsModeratedByAppInstanceUserPaginated, request)
            def updateChannelMessage(request: UpdateChannelMessageRequest): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.UpdateChannelMessageResponse.ReadOnly
            ] = proxy(UpdateChannelMessage, request)
            def getMessagingSessionEndpoint(
                request: GetMessagingSessionEndpointRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.GetMessagingSessionEndpointResponse.ReadOnly
            ] = proxy(GetMessagingSessionEndpoint, request)
            def putMessagingStreamingConfigurations(
                request: PutMessagingStreamingConfigurationsRequest
            ): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.PutMessagingStreamingConfigurationsResponse.ReadOnly
            ] = proxy(PutMessagingStreamingConfigurations, request)
            def updateChannel(request: UpdateChannelRequest): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.UpdateChannelResponse.ReadOnly
            ] = proxy(UpdateChannel, request)
            def describeChannelFlow(request: DescribeChannelFlowRequest): IO[
              AwsError,
              zio.aws.chimesdkmessaging.model.DescribeChannelFlowResponse.ReadOnly
            ] = proxy(DescribeChannelFlow, request)
          }
        }
      }
    }
  }
}
