package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class UpdateChannelFlowResponse(
    channelFlowArn: Optional[ChimeArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelFlowResponse = {
    import UpdateChannelFlowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelFlowResponse
      .builder()
      .optionallyWith(
        channelFlowArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelFlowArn)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.UpdateChannelFlowResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.UpdateChannelFlowResponse
      .wrap(buildAwsValue())
}
object UpdateChannelFlowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelFlowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.UpdateChannelFlowResponse =
      zio.aws.chimesdkmessaging.model
        .UpdateChannelFlowResponse(channelFlowArn.map(value => value))
    def channelFlowArn: Optional[ChimeArn]
    def getChannelFlowArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelFlowArn", channelFlowArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelFlowResponse
  ) extends zio.aws.chimesdkmessaging.model.UpdateChannelFlowResponse.ReadOnly {
    override val channelFlowArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelFlowArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelFlowResponse
  ): zio.aws.chimesdkmessaging.model.UpdateChannelFlowResponse.ReadOnly =
    new Wrapper(impl)
}
