package zio.aws.chimesdkmessaging.model
import zio.aws.chimesdkmessaging.model.primitives.{
  SubChannelId,
  NextToken,
  MaxResults,
  ChimeArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListChannelMembershipsRequest(
    channelArn: ChimeArn,
    `type`: Optional[zio.aws.chimesdkmessaging.model.ChannelMembershipType] =
      Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    chimeBearer: ChimeArn,
    subChannelId: Optional[SubChannelId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMembershipsRequest = {
    import ListChannelMembershipsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMembershipsRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .chimeBearer(ChimeArn.unwrap(chimeBearer): java.lang.String)
      .optionallyWith(
        subChannelId.map(value => SubChannelId.unwrap(value): java.lang.String)
      )(_.subChannelId)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ListChannelMembershipsRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.ListChannelMembershipsRequest
      .wrap(buildAwsValue())
}
object ListChannelMembershipsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMembershipsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.ListChannelMembershipsRequest =
      zio.aws.chimesdkmessaging.model.ListChannelMembershipsRequest(
        channelArn,
        `type`.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        chimeBearer,
        subChannelId.map(value => value)
      )
    def channelArn: ChimeArn
    def `type`: Optional[zio.aws.chimesdkmessaging.model.ChannelMembershipType]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def chimeBearer: ChimeArn
    def subChannelId: Optional[SubChannelId]
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelMembershipType
    ] = AwsError.unwrapOptionField("type", `type`)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getChimeBearer: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(chimeBearer)
    def getSubChannelId: ZIO[Any, AwsError, SubChannelId] =
      AwsError.unwrapOptionField("subChannelId", subChannelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMembershipsRequest
  ) extends zio.aws.chimesdkmessaging.model.ListChannelMembershipsRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelArn())
    override val `type`
        : Optional[zio.aws.chimesdkmessaging.model.ChannelMembershipType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.chimesdkmessaging.model.ChannelMembershipType.wrap(value)
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.MaxResults(value)
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.NextToken(value))
    override val chimeBearer: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.chimeBearer())
    override val subChannelId: Optional[SubChannelId] = zio.aws.core.internal
      .optionalFromNullable(impl.subChannelId())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.SubChannelId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMembershipsRequest
  ): zio.aws.chimesdkmessaging.model.ListChannelMembershipsRequest.ReadOnly =
    new Wrapper(impl)
}
