package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.{
  Metadata,
  ChimeArn,
  NonEmptyResourceName
}
import scala.jdk.CollectionConverters._
final case class ChannelAssociatedWithFlowSummary(
    name: Optional[NonEmptyResourceName] = Optional.Absent,
    channelArn: Optional[ChimeArn] = Optional.Absent,
    mode: Optional[zio.aws.chimesdkmessaging.model.ChannelMode] =
      Optional.Absent,
    privacy: Optional[zio.aws.chimesdkmessaging.model.ChannelPrivacy] =
      Optional.Absent,
    metadata: Optional[Metadata] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary = {
    import ChannelAssociatedWithFlowSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(privacy.map(value => value.unwrap))(_.privacy)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary.ReadOnly =
    zio.aws.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary
      .wrap(buildAwsValue())
}
object ChannelAssociatedWithFlowSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary =
      zio.aws.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary(
        name.map(value => value),
        channelArn.map(value => value),
        mode.map(value => value),
        privacy.map(value => value),
        metadata.map(value => value)
      )
    def name: Optional[NonEmptyResourceName]
    def channelArn: Optional[ChimeArn]
    def mode: Optional[zio.aws.chimesdkmessaging.model.ChannelMode]
    def privacy: Optional[zio.aws.chimesdkmessaging.model.ChannelPrivacy]
    def metadata: Optional[Metadata]
    def getName: ZIO[Any, AwsError, NonEmptyResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getMode
        : ZIO[Any, AwsError, zio.aws.chimesdkmessaging.model.ChannelMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getPrivacy
        : ZIO[Any, AwsError, zio.aws.chimesdkmessaging.model.ChannelPrivacy] =
      AwsError.unwrapOptionField("privacy", privacy)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary
  ) extends zio.aws.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary.ReadOnly {
    override val name: Optional[NonEmptyResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.NonEmptyResourceName(value)
      )
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val mode: Optional[zio.aws.chimesdkmessaging.model.ChannelMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value => zio.aws.chimesdkmessaging.model.ChannelMode.wrap(value))
    override val privacy
        : Optional[zio.aws.chimesdkmessaging.model.ChannelPrivacy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privacy())
        .map(value =>
          zio.aws.chimesdkmessaging.model.ChannelPrivacy.wrap(value)
        )
    override val metadata: Optional[Metadata] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Metadata(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary
  ): zio.aws.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary.ReadOnly =
    new Wrapper(impl)
}
