package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class PutChannelExpirationSettingsRequest(
    channelArn: ChimeArn,
    chimeBearer: Optional[ChimeArn] = Optional.Absent,
    expirationSettings: Optional[
      zio.aws.chimesdkmessaging.model.ExpirationSettings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.PutChannelExpirationSettingsRequest = {
    import PutChannelExpirationSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.PutChannelExpirationSettingsRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .optionallyWith(
        chimeBearer.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.chimeBearer)
      .optionallyWith(expirationSettings.map(value => value.buildAwsValue()))(
        _.expirationSettings
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.PutChannelExpirationSettingsRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.PutChannelExpirationSettingsRequest
      .wrap(buildAwsValue())
}
object PutChannelExpirationSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.PutChannelExpirationSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.PutChannelExpirationSettingsRequest =
      zio.aws.chimesdkmessaging.model.PutChannelExpirationSettingsRequest(
        channelArn,
        chimeBearer.map(value => value),
        expirationSettings.map(value => value.asEditable)
      )
    def channelArn: ChimeArn
    def chimeBearer: Optional[ChimeArn]
    def expirationSettings
        : Optional[zio.aws.chimesdkmessaging.model.ExpirationSettings.ReadOnly]
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getChimeBearer: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("chimeBearer", chimeBearer)
    def getExpirationSettings: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ExpirationSettings.ReadOnly
    ] = AwsError.unwrapOptionField("expirationSettings", expirationSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.PutChannelExpirationSettingsRequest
  ) extends zio.aws.chimesdkmessaging.model.PutChannelExpirationSettingsRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelArn())
    override val chimeBearer: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.chimeBearer())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val expirationSettings: Optional[
      zio.aws.chimesdkmessaging.model.ExpirationSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.expirationSettings())
      .map(value =>
        zio.aws.chimesdkmessaging.model.ExpirationSettings.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.PutChannelExpirationSettingsRequest
  ): zio.aws.chimesdkmessaging.model.PutChannelExpirationSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
