package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class DeleteMessagingStreamingConfigurationsRequest(
    appInstanceArn: ChimeArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.DeleteMessagingStreamingConfigurationsRequest = {
    import DeleteMessagingStreamingConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.DeleteMessagingStreamingConfigurationsRequest
      .builder()
      .appInstanceArn(ChimeArn.unwrap(appInstanceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.DeleteMessagingStreamingConfigurationsRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.DeleteMessagingStreamingConfigurationsRequest
      .wrap(buildAwsValue())
}
object DeleteMessagingStreamingConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.DeleteMessagingStreamingConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.DeleteMessagingStreamingConfigurationsRequest =
      zio.aws.chimesdkmessaging.model
        .DeleteMessagingStreamingConfigurationsRequest(appInstanceArn)
    def appInstanceArn: ChimeArn
    def getAppInstanceArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(appInstanceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.DeleteMessagingStreamingConfigurationsRequest
  ) extends zio.aws.chimesdkmessaging.model.DeleteMessagingStreamingConfigurationsRequest.ReadOnly {
    override val appInstanceArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.appInstanceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.DeleteMessagingStreamingConfigurationsRequest
  ): zio.aws.chimesdkmessaging.model.DeleteMessagingStreamingConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
