package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class CreateChannelModeratorResponse(
    channelArn: Optional[ChimeArn] = Optional.Absent,
    channelModerator: Optional[zio.aws.chimesdkmessaging.model.Identity] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelModeratorResponse = {
    import CreateChannelModeratorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelModeratorResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(channelModerator.map(value => value.buildAwsValue()))(
        _.channelModerator
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.CreateChannelModeratorResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.CreateChannelModeratorResponse
      .wrap(buildAwsValue())
}
object CreateChannelModeratorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelModeratorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.CreateChannelModeratorResponse =
      zio.aws.chimesdkmessaging.model.CreateChannelModeratorResponse(
        channelArn.map(value => value),
        channelModerator.map(value => value.asEditable)
      )
    def channelArn: Optional[ChimeArn]
    def channelModerator
        : Optional[zio.aws.chimesdkmessaging.model.Identity.ReadOnly]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getChannelModerator: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.Identity.ReadOnly
    ] = AwsError.unwrapOptionField("channelModerator", channelModerator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelModeratorResponse
  ) extends zio.aws.chimesdkmessaging.model.CreateChannelModeratorResponse.ReadOnly {
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val channelModerator
        : Optional[zio.aws.chimesdkmessaging.model.Identity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channelModerator())
        .map(value => zio.aws.chimesdkmessaging.model.Identity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.CreateChannelModeratorResponse
  ): zio.aws.chimesdkmessaging.model.CreateChannelModeratorResponse.ReadOnly =
    new Wrapper(impl)
}
