package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.{NextToken, ChimeArn}
import scala.jdk.CollectionConverters._
final case class ListSubChannelsResponse(
    channelArn: Optional[ChimeArn] = Optional.Absent,
    subChannels: Optional[
      Iterable[zio.aws.chimesdkmessaging.model.SubChannelSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ListSubChannelsResponse = {
    import ListSubChannelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ListSubChannelsResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        subChannels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subChannels)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ListSubChannelsResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.ListSubChannelsResponse
      .wrap(buildAwsValue())
}
object ListSubChannelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ListSubChannelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.ListSubChannelsResponse =
      zio.aws.chimesdkmessaging.model.ListSubChannelsResponse(
        channelArn.map(value => value),
        subChannels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def channelArn: Optional[ChimeArn]
    def subChannels: Optional[
      List[zio.aws.chimesdkmessaging.model.SubChannelSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getSubChannels: ZIO[Any, AwsError, List[
      zio.aws.chimesdkmessaging.model.SubChannelSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("subChannels", subChannels)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListSubChannelsResponse
  ) extends zio.aws.chimesdkmessaging.model.ListSubChannelsResponse.ReadOnly {
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val subChannels: Optional[
      List[zio.aws.chimesdkmessaging.model.SubChannelSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.subChannels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chimesdkmessaging.model.SubChannelSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListSubChannelsResponse
  ): zio.aws.chimesdkmessaging.model.ListSubChannelsResponse.ReadOnly =
    new Wrapper(impl)
}
