package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.{SubChannelId, ChimeArn}
import scala.jdk.CollectionConverters._
final case class DeleteChannelMembershipRequest(
    channelArn: ChimeArn,
    memberArn: ChimeArn,
    chimeBearer: ChimeArn,
    subChannelId: Optional[SubChannelId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.DeleteChannelMembershipRequest = {
    import DeleteChannelMembershipRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.DeleteChannelMembershipRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .memberArn(ChimeArn.unwrap(memberArn): java.lang.String)
      .chimeBearer(ChimeArn.unwrap(chimeBearer): java.lang.String)
      .optionallyWith(
        subChannelId.map(value => SubChannelId.unwrap(value): java.lang.String)
      )(_.subChannelId)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.DeleteChannelMembershipRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.DeleteChannelMembershipRequest
      .wrap(buildAwsValue())
}
object DeleteChannelMembershipRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.DeleteChannelMembershipRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.DeleteChannelMembershipRequest =
      zio.aws.chimesdkmessaging.model.DeleteChannelMembershipRequest(
        channelArn,
        memberArn,
        chimeBearer,
        subChannelId.map(value => value)
      )
    def channelArn: ChimeArn
    def memberArn: ChimeArn
    def chimeBearer: ChimeArn
    def subChannelId: Optional[SubChannelId]
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getMemberArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(memberArn)
    def getChimeBearer: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(chimeBearer)
    def getSubChannelId: ZIO[Any, AwsError, SubChannelId] =
      AwsError.unwrapOptionField("subChannelId", subChannelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.DeleteChannelMembershipRequest
  ) extends zio.aws.chimesdkmessaging.model.DeleteChannelMembershipRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.channelArn())
    override val memberArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.memberArn())
    override val chimeBearer: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.chimeBearer())
    override val subChannelId: Optional[SubChannelId] = zio.aws.core.internal
      .optionalFromNullable(impl.subChannelId())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.SubChannelId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.DeleteChannelMembershipRequest
  ): zio.aws.chimesdkmessaging.model.DeleteChannelMembershipRequest.ReadOnly =
    new Wrapper(impl)
}
