package zio.aws.chimesdkmessaging.model
import zio.aws.chimesdkmessaging.model.primitives.{
  MessageId,
  MessageAttributeName,
  Timestamp,
  NonNullableBoolean,
  Content,
  Metadata
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ChannelMessageSummary(
    messageId: Optional[MessageId] = Optional.Absent,
    content: Optional[Content] = Optional.Absent,
    metadata: Optional[Metadata] = Optional.Absent,
    `type`: Optional[zio.aws.chimesdkmessaging.model.ChannelMessageType] =
      Optional.Absent,
    createdTimestamp: Optional[Timestamp] = Optional.Absent,
    lastUpdatedTimestamp: Optional[Timestamp] = Optional.Absent,
    lastEditedTimestamp: Optional[Timestamp] = Optional.Absent,
    sender: Optional[zio.aws.chimesdkmessaging.model.Identity] =
      Optional.Absent,
    redacted: Optional[NonNullableBoolean] = Optional.Absent,
    status: Optional[
      zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure
    ] = Optional.Absent,
    messageAttributes: Optional[Map[
      MessageAttributeName,
      zio.aws.chimesdkmessaging.model.MessageAttributeValue
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageSummary = {
    import ChannelMessageSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageSummary
      .builder()
      .optionallyWith(
        messageId.map(value => MessageId.unwrap(value): java.lang.String)
      )(_.messageId)
      .optionallyWith(
        content.map(value => Content.unwrap(value): java.lang.String)
      )(_.content)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        lastUpdatedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTimestamp)
      .optionallyWith(
        lastEditedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastEditedTimestamp)
      .optionallyWith(sender.map(value => value.buildAwsValue()))(_.sender)
      .optionallyWith(
        redacted.map(value =>
          NonNullableBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.redacted)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(
        messageAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (MessageAttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.messageAttributes)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ChannelMessageSummary.ReadOnly =
    zio.aws.chimesdkmessaging.model.ChannelMessageSummary.wrap(buildAwsValue())
}
object ChannelMessageSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.ChannelMessageSummary =
      zio.aws.chimesdkmessaging.model.ChannelMessageSummary(
        messageId.map(value => value),
        content.map(value => value),
        metadata.map(value => value),
        `type`.map(value => value),
        createdTimestamp.map(value => value),
        lastUpdatedTimestamp.map(value => value),
        lastEditedTimestamp.map(value => value),
        sender.map(value => value.asEditable),
        redacted.map(value => value),
        status.map(value => value.asEditable),
        messageAttributes.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def messageId: Optional[MessageId]
    def content: Optional[Content]
    def metadata: Optional[Metadata]
    def `type`: Optional[zio.aws.chimesdkmessaging.model.ChannelMessageType]
    def createdTimestamp: Optional[Timestamp]
    def lastUpdatedTimestamp: Optional[Timestamp]
    def lastEditedTimestamp: Optional[Timestamp]
    def sender: Optional[zio.aws.chimesdkmessaging.model.Identity.ReadOnly]
    def redacted: Optional[NonNullableBoolean]
    def status: Optional[
      zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure.ReadOnly
    ]
    def messageAttributes: Optional[Map[
      MessageAttributeName,
      zio.aws.chimesdkmessaging.model.MessageAttributeValue.ReadOnly
    ]]
    def getMessageId: ZIO[Any, AwsError, MessageId] =
      AwsError.unwrapOptionField("messageId", messageId)
    def getContent: ZIO[Any, AwsError, Content] =
      AwsError.unwrapOptionField("content", content)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelMessageType
    ] = AwsError.unwrapOptionField("type", `type`)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
    def getLastEditedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastEditedTimestamp", lastEditedTimestamp)
    def getSender: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.Identity.ReadOnly
    ] = AwsError.unwrapOptionField("sender", sender)
    def getRedacted: ZIO[Any, AwsError, NonNullableBoolean] =
      AwsError.unwrapOptionField("redacted", redacted)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getMessageAttributes: ZIO[Any, AwsError, Map[
      MessageAttributeName,
      zio.aws.chimesdkmessaging.model.MessageAttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("messageAttributes", messageAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageSummary
  ) extends zio.aws.chimesdkmessaging.model.ChannelMessageSummary.ReadOnly {
    override val messageId: Optional[MessageId] = zio.aws.core.internal
      .optionalFromNullable(impl.messageId())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.MessageId(value))
    override val content: Optional[Content] = zio.aws.core.internal
      .optionalFromNullable(impl.content())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Content(value))
    override val metadata: Optional[Metadata] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Metadata(value))
    override val `type`
        : Optional[zio.aws.chimesdkmessaging.model.ChannelMessageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.chimesdkmessaging.model.ChannelMessageType.wrap(value)
        )
    override val createdTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimestamp())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.Timestamp(value))
    override val lastUpdatedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTimestamp())
        .map(value =>
          zio.aws.chimesdkmessaging.model.primitives.Timestamp(value)
        )
    override val lastEditedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastEditedTimestamp())
        .map(value =>
          zio.aws.chimesdkmessaging.model.primitives.Timestamp(value)
        )
    override val sender
        : Optional[zio.aws.chimesdkmessaging.model.Identity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sender())
        .map(value => zio.aws.chimesdkmessaging.model.Identity.wrap(value))
    override val redacted: Optional[NonNullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.redacted())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.NonNullableBoolean(value)
      )
    override val status: Optional[
      zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure
          .wrap(value)
      )
    override val messageAttributes: Optional[Map[
      MessageAttributeName,
      zio.aws.chimesdkmessaging.model.MessageAttributeValue.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.messageAttributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.chimesdkmessaging.model.primitives.MessageAttributeName(
              key
            ) -> zio.aws.chimesdkmessaging.model.MessageAttributeValue
              .wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageSummary
  ): zio.aws.chimesdkmessaging.model.ChannelMessageSummary.ReadOnly =
    new Wrapper(impl)
}
