package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.ChimeArn
import scala.jdk.CollectionConverters._
final case class BatchCreateChannelMembershipError(
    memberArn: Optional[ChimeArn] = Optional.Absent,
    errorCode: Optional[zio.aws.chimesdkmessaging.model.ErrorCode] =
      Optional.Absent,
    errorMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.BatchCreateChannelMembershipError = {
    import BatchCreateChannelMembershipError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.BatchCreateChannelMembershipError
      .builder()
      .optionallyWith(
        memberArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.memberArn)
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipError.ReadOnly =
    zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipError
      .wrap(buildAwsValue())
}
object BatchCreateChannelMembershipError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.BatchCreateChannelMembershipError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipError =
      zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipError(
        memberArn.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def memberArn: Optional[ChimeArn]
    def errorCode: Optional[zio.aws.chimesdkmessaging.model.ErrorCode]
    def errorMessage: Optional[String]
    def getMemberArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("memberArn", memberArn)
    def getErrorCode
        : ZIO[Any, AwsError, zio.aws.chimesdkmessaging.model.ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.BatchCreateChannelMembershipError
  ) extends zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipError.ReadOnly {
    override val memberArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.memberArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val errorCode
        : Optional[zio.aws.chimesdkmessaging.model.ErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value => zio.aws.chimesdkmessaging.model.ErrorCode.wrap(value))
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.BatchCreateChannelMembershipError
  ): zio.aws.chimesdkmessaging.model.BatchCreateChannelMembershipError.ReadOnly =
    new Wrapper(impl)
}
