package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.{SubChannelId, ChimeArn}
import scala.jdk.CollectionConverters._
final case class UpdateChannelReadMarkerResponse(
    channelArn: Optional[ChimeArn] = Optional.Absent,
    subChannelId: Optional[SubChannelId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelReadMarkerResponse = {
    import UpdateChannelReadMarkerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelReadMarkerResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        subChannelId.map(value => SubChannelId.unwrap(value): java.lang.String)
      )(_.subChannelId)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.UpdateChannelReadMarkerResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.UpdateChannelReadMarkerResponse
      .wrap(buildAwsValue())
}
object UpdateChannelReadMarkerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelReadMarkerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.UpdateChannelReadMarkerResponse =
      zio.aws.chimesdkmessaging.model.UpdateChannelReadMarkerResponse(
        channelArn.map(value => value),
        subChannelId.map(value => value)
      )
    def channelArn: Optional[ChimeArn]
    def subChannelId: Optional[SubChannelId]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getSubChannelId: ZIO[Any, AwsError, SubChannelId] =
      AwsError.unwrapOptionField("subChannelId", subChannelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelReadMarkerResponse
  ) extends zio.aws.chimesdkmessaging.model.UpdateChannelReadMarkerResponse.ReadOnly {
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val subChannelId: Optional[SubChannelId] = zio.aws.core.internal
      .optionalFromNullable(impl.subChannelId())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.SubChannelId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelReadMarkerResponse
  ): zio.aws.chimesdkmessaging.model.UpdateChannelReadMarkerResponse.ReadOnly =
    new Wrapper(impl)
}
