package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.{
  PushNotificationBody,
  PushNotificationTitle
}
import scala.jdk.CollectionConverters._
final case class PushNotificationConfiguration(
    title: Optional[PushNotificationTitle] = Optional.Absent,
    body: Optional[PushNotificationBody] = Optional.Absent,
    `type`: Optional[zio.aws.chimesdkmessaging.model.PushNotificationType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.PushNotificationConfiguration = {
    import PushNotificationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.PushNotificationConfiguration
      .builder()
      .optionallyWith(
        title.map(value =>
          PushNotificationTitle.unwrap(value): java.lang.String
        )
      )(_.title)
      .optionallyWith(
        body.map(value => PushNotificationBody.unwrap(value): java.lang.String)
      )(_.body)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.PushNotificationConfiguration.ReadOnly =
    zio.aws.chimesdkmessaging.model.PushNotificationConfiguration
      .wrap(buildAwsValue())
}
object PushNotificationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.PushNotificationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.PushNotificationConfiguration =
      zio.aws.chimesdkmessaging.model.PushNotificationConfiguration(
        title.map(value => value),
        body.map(value => value),
        `type`.map(value => value)
      )
    def title: Optional[PushNotificationTitle]
    def body: Optional[PushNotificationBody]
    def `type`: Optional[zio.aws.chimesdkmessaging.model.PushNotificationType]
    def getTitle: ZIO[Any, AwsError, PushNotificationTitle] =
      AwsError.unwrapOptionField("title", title)
    def getBody: ZIO[Any, AwsError, PushNotificationBody] =
      AwsError.unwrapOptionField("body", body)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.PushNotificationType
    ] = AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.PushNotificationConfiguration
  ) extends zio.aws.chimesdkmessaging.model.PushNotificationConfiguration.ReadOnly {
    override val title: Optional[PushNotificationTitle] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.PushNotificationTitle(value)
      )
    override val body: Optional[PushNotificationBody] = zio.aws.core.internal
      .optionalFromNullable(impl.body())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.PushNotificationBody(value)
      )
    override val `type`
        : Optional[zio.aws.chimesdkmessaging.model.PushNotificationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.chimesdkmessaging.model.PushNotificationType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.PushNotificationConfiguration
  ): zio.aws.chimesdkmessaging.model.PushNotificationConfiguration.ReadOnly =
    new Wrapper(impl)
}
