package zio.aws.chimesdkmessaging.model
import zio.aws.chimesdkmessaging.model.primitives.{
  NextToken,
  MaxResults,
  ChimeArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListChannelFlowsRequest(
    appInstanceArn: ChimeArn,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelFlowsRequest = {
    import ListChannelFlowsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelFlowsRequest
      .builder()
      .appInstanceArn(ChimeArn.unwrap(appInstanceArn): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.ListChannelFlowsRequest.ReadOnly =
    zio.aws.chimesdkmessaging.model.ListChannelFlowsRequest
      .wrap(buildAwsValue())
}
object ListChannelFlowsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelFlowsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chimesdkmessaging.model.ListChannelFlowsRequest =
      zio.aws.chimesdkmessaging.model.ListChannelFlowsRequest(
        appInstanceArn,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def appInstanceArn: ChimeArn
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getAppInstanceArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(appInstanceArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelFlowsRequest
  ) extends zio.aws.chimesdkmessaging.model.ListChannelFlowsRequest.ReadOnly {
    override val appInstanceArn: ChimeArn =
      zio.aws.chimesdkmessaging.model.primitives.ChimeArn(impl.appInstanceArn())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.MaxResults(value)
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelFlowsRequest
  ): zio.aws.chimesdkmessaging.model.ListChannelFlowsRequest.ReadOnly =
    new Wrapper(impl)
}
