package zio.aws.chimesdkmessaging.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.chimesdkmessaging.model.primitives.{
  SubChannelId,
  MessageId,
  ChimeArn
}
import scala.jdk.CollectionConverters._
final case class UpdateChannelMessageResponse(
    channelArn: Optional[ChimeArn] = Optional.Absent,
    messageId: Optional[MessageId] = Optional.Absent,
    status: Optional[
      zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure
    ] = Optional.Absent,
    subChannelId: Optional[SubChannelId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelMessageResponse = {
    import UpdateChannelMessageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelMessageResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        messageId.map(value => MessageId.unwrap(value): java.lang.String)
      )(_.messageId)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(
        subChannelId.map(value => SubChannelId.unwrap(value): java.lang.String)
      )(_.subChannelId)
      .build()
  }
  def asReadOnly
      : zio.aws.chimesdkmessaging.model.UpdateChannelMessageResponse.ReadOnly =
    zio.aws.chimesdkmessaging.model.UpdateChannelMessageResponse
      .wrap(buildAwsValue())
}
object UpdateChannelMessageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelMessageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chimesdkmessaging.model.UpdateChannelMessageResponse =
      zio.aws.chimesdkmessaging.model.UpdateChannelMessageResponse(
        channelArn.map(value => value),
        messageId.map(value => value),
        status.map(value => value.asEditable),
        subChannelId.map(value => value)
      )
    def channelArn: Optional[ChimeArn]
    def messageId: Optional[MessageId]
    def status: Optional[
      zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure.ReadOnly
    ]
    def subChannelId: Optional[SubChannelId]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getMessageId: ZIO[Any, AwsError, MessageId] =
      AwsError.unwrapOptionField("messageId", messageId)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getSubChannelId: ZIO[Any, AwsError, SubChannelId] =
      AwsError.unwrapOptionField("subChannelId", subChannelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelMessageResponse
  ) extends zio.aws.chimesdkmessaging.model.UpdateChannelMessageResponse.ReadOnly {
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.ChimeArn(value))
    override val messageId: Optional[MessageId] = zio.aws.core.internal
      .optionalFromNullable(impl.messageId())
      .map(value => zio.aws.chimesdkmessaging.model.primitives.MessageId(value))
    override val status: Optional[
      zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.chimesdkmessaging.model.ChannelMessageStatusStructure
          .wrap(value)
      )
    override val subChannelId: Optional[SubChannelId] = zio.aws.core.internal
      .optionalFromNullable(impl.subChannelId())
      .map(value =>
        zio.aws.chimesdkmessaging.model.primitives.SubChannelId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chimesdkmessaging.model.UpdateChannelMessageResponse
  ): zio.aws.chimesdkmessaging.model.UpdateChannelMessageResponse.ReadOnly =
    new Wrapper(impl)
}
